#!/bin/bash

# set -euo pipefail

./scripts/setup.sh

function run {
    for suffix_trained_xgboost_model_folder_path in "${trained_xgboost_model_folder_paths[@]}"; do
        trained_xgboost_model_folder_path="${xgboost_models_dir}/${suffix_trained_xgboost_model_folder_path}"
        for F in "${Fs[@]}"; do
            F_str=$(echo $F | sed 's/\.//g')
            sandwichedlbf_folder_path="${sandwichedlbf_dir_root}/${suffix_trained_xgboost_model_folder_path}/F_${F_str}"
            for pos_query_ratio in "${pos_query_ratios[@]}"; do
                pos_query_ratio_str=$(echo $pos_query_ratio | sed 's/\.//g')
                for query_num in "${query_nums[@]}"; do
                    result_folder_path="${result_dir_root}/${suffix_trained_xgboost_model_folder_path}/F_${F_str}/pr_${pos_query_ratio_str}_qn_${query_num}"
                    mkdir -p "$result_folder_path"
                    ./experiment/build/test_sandwichedlbf \
                        -k "$X_test_key_path" \
                        -x "$X_test_path" \
                        -y "$y_test_path" \
                        -m "$sandwichedlbf_folder_path" \
                        -o "$result_folder_path" \
                        -p $pos_query_ratio \
                        -q $query_num
                    exit_code=$?
                    if [ $exit_code -ne 0 ]; then
                        echo "Failed to test sandwiched LBF for directory: $sandwichedlbf_folder_path"
                        rm -rf "$output_dir"
                    fi
                done
            done
        done
    done
}

datasets=("url" "ember")
for dataset in "${datasets[@]}"; do
    xgboost_models_dir="models/${dataset}/xgboost"
    sandwichedlbf_dir_root="models/${dataset}/sandwichedlbf"
    result_dir_root="results/${dataset}/sandwichedlbf"
    X_test_key_path="data/${dataset}/preprocessed/X_test_key.bin"
    X_test_path="data/${dataset}/preprocessed/X_test.bin"
    y_test_path="data/${dataset}/preprocessed/y_test.bin"

    # memory <-> fpr trade-off
    trained_xgboost_model_folder_paths=(
        "max_depth_1_num_boost_round_1_eta_03"
        "max_depth_1_num_boost_round_10_eta_03"
        "max_depth_1_num_boost_round_100_eta_03"
        "max_depth_2_num_boost_round_1_eta_03"
        "max_depth_2_num_boost_round_10_eta_03"
        "max_depth_2_num_boost_round_100_eta_03"
        "max_depth_4_num_boost_round_1_eta_03"
        "max_depth_4_num_boost_round_10_eta_03"
        "max_depth_4_num_boost_round_100_eta_03"
        "max_depth_6_num_boost_round_1_eta_03"
        "max_depth_6_num_boost_round_10_eta_03"
        "max_depth_6_num_boost_round_100_eta_03"
    )
    Fs=(0.1 0.05 0.02 0.01 0.005 0.002 0.001)
    pos_query_ratios=(0.0)
    query_nums=(40000)
    run

    # memory <-> reject time trade-off
    trained_xgboost_model_folder_paths=(
        "max_depth_1_num_boost_round_1_eta_03"
        "max_depth_1_num_boost_round_2_eta_03"
        "max_depth_1_num_boost_round_3_eta_03"
        "max_depth_1_num_boost_round_4_eta_03"
        "max_depth_1_num_boost_round_5_eta_03"
        "max_depth_1_num_boost_round_6_eta_03"
        "max_depth_1_num_boost_round_7_eta_03"
        "max_depth_1_num_boost_round_8_eta_03"
        "max_depth_1_num_boost_round_9_eta_03"
        "max_depth_1_num_boost_round_10_eta_03"
        "max_depth_1_num_boost_round_20_eta_03"
        "max_depth_1_num_boost_round_30_eta_03"
        "max_depth_1_num_boost_round_40_eta_03"
        "max_depth_1_num_boost_round_50_eta_03"
        "max_depth_1_num_boost_round_60_eta_03"
        "max_depth_1_num_boost_round_70_eta_03"
        "max_depth_1_num_boost_round_80_eta_03"
        "max_depth_1_num_boost_round_90_eta_03"
        "max_depth_1_num_boost_round_100_eta_03"
        "max_depth_2_num_boost_round_1_eta_03"
        "max_depth_2_num_boost_round_2_eta_03"
        "max_depth_2_num_boost_round_3_eta_03"
        "max_depth_2_num_boost_round_4_eta_03"
        "max_depth_2_num_boost_round_5_eta_03"
        "max_depth_2_num_boost_round_6_eta_03"
        "max_depth_2_num_boost_round_7_eta_03"
        "max_depth_2_num_boost_round_8_eta_03"
        "max_depth_2_num_boost_round_9_eta_03"
        "max_depth_2_num_boost_round_10_eta_03"
        "max_depth_2_num_boost_round_20_eta_03"
        "max_depth_2_num_boost_round_30_eta_03"
        "max_depth_2_num_boost_round_40_eta_03"
        "max_depth_2_num_boost_round_50_eta_03"
        "max_depth_2_num_boost_round_60_eta_03"
        "max_depth_2_num_boost_round_70_eta_03"
        "max_depth_2_num_boost_round_80_eta_03"
        "max_depth_2_num_boost_round_90_eta_03"
        "max_depth_2_num_boost_round_100_eta_03"
        "max_depth_4_num_boost_round_1_eta_03"
        "max_depth_4_num_boost_round_2_eta_03"
        "max_depth_4_num_boost_round_3_eta_03"
        "max_depth_4_num_boost_round_4_eta_03"
        "max_depth_4_num_boost_round_5_eta_03"
        "max_depth_4_num_boost_round_6_eta_03"
        "max_depth_4_num_boost_round_7_eta_03"
        "max_depth_4_num_boost_round_8_eta_03"
        "max_depth_4_num_boost_round_9_eta_03"
        "max_depth_4_num_boost_round_10_eta_03"
        "max_depth_4_num_boost_round_20_eta_03"
        "max_depth_4_num_boost_round_30_eta_03"
        "max_depth_4_num_boost_round_40_eta_03"
        "max_depth_4_num_boost_round_50_eta_03"
        "max_depth_4_num_boost_round_60_eta_03"
        "max_depth_4_num_boost_round_70_eta_03"
        "max_depth_4_num_boost_round_80_eta_03"
        "max_depth_4_num_boost_round_90_eta_03"
        "max_depth_4_num_boost_round_100_eta_03"
        "max_depth_6_num_boost_round_1_eta_03"
        "max_depth_6_num_boost_round_2_eta_03"
        "max_depth_6_num_boost_round_3_eta_03"
        "max_depth_6_num_boost_round_4_eta_03"
        "max_depth_6_num_boost_round_5_eta_03"
        "max_depth_6_num_boost_round_6_eta_03"
        "max_depth_6_num_boost_round_7_eta_03"
        "max_depth_6_num_boost_round_8_eta_03"
        "max_depth_6_num_boost_round_9_eta_03"
        "max_depth_6_num_boost_round_10_eta_03"
        "max_depth_6_num_boost_round_20_eta_03"
        "max_depth_6_num_boost_round_30_eta_03"
        "max_depth_6_num_boost_round_40_eta_03"
        "max_depth_6_num_boost_round_50_eta_03"
        "max_depth_6_num_boost_round_60_eta_03"
        "max_depth_6_num_boost_round_70_eta_03"
        "max_depth_6_num_boost_round_80_eta_03"
        "max_depth_6_num_boost_round_90_eta_03"
        "max_depth_6_num_boost_round_100_eta_03"
    )
    Fs=(0.1 0.01 0.001)
    pos_query_ratios=(0.0)
    query_nums=(40000)
    run
done
