#!/bin/bash

set -euo pipefail

./scripts/setup.sh

function run {
    for max_depth in "${max_depths[@]}"; do
        for num_boost_round in "${num_boost_rounds[@]}"; do
            for eta in "${etas[@]}"; do
                eta_str=$(echo $eta | sed 's/\.//g')
                output_dir="${model_root_dir}/max_depth_${max_depth}_num_boost_round_${num_boost_round}_eta_${eta_str}"
                mkdir -p "$output_dir"
                ./experiment/build/train_xgboost \
                    -x "$X_train_path" \
                    -y "$y_train_path" \
                    -o "$output_dir" \
                    -d $max_depth \
                    -r $num_boost_round \
                    -e $eta
            done
        done
    done
}

datasets=("url" "ember")
for dataset in "${datasets[@]}"; do
    X_train_path="data/${dataset}/preprocessed/X_train.bin"
    y_train_path="data/${dataset}/preprocessed/y_train.bin"
    model_root_dir="models/${dataset}/xgboost"

    max_depths=(1 2 4 6)
    num_boost_rounds=(1 2 3 4 5 6 7 8 9 10 20 30 40 50 60 70 80 90 100)
    etas=(0.3)
    run
done
