// burger_config.h
#ifndef BURGER_CONFIG_H
#define BURGER_CONFIG_H

#include <vector>
#include <iostream>

struct BurgerConfig {
    int d;           // Depth of the Bloom filter
    int k;           // Number of regions at the final layer
    long int n;      // Number of positive samples
    // std::vector<float> b;  // FPRs of Branch Bloom Filter
    // std::vector<float> t;  // FPRs of Trunk Bloom Filter
    std::vector<float> f;  // FPRs of Final Bloom Filter
    // std::vector<float> th_b; // Thresholds for Branch/Trunk Bloom Filter
    std::vector<float> th_f; // Thresholds for Final Bloom Filter
    // std::vector<float> g_b;  // Branch Bloom filter statistics
    // std::vector<float> g_t;  // Trunk Bloom filter statistics
    std::vector<float> g_f;  // Final Bloom filter statistics

    void print() {
        std::cout << "d: " << d << std::endl;
        std::cout << "k: " << k << std::endl;
        std::cout << "n: " << n << std::endl;
        // std::cout << "b: ";
        // for (float bi : b) {
        //     std::cout << bi << " ";
        // }
        // std::cout << std::endl;
        // std::cout << "t: ";
        // for (float ti : t) {
        //     std::cout << ti << " ";
        // }
        // std::cout << std::endl;
        std::cout << "f: ";
        for (float fi : f) {
            std::cout << fi << " ";
        }
        std::cout << std::endl;
        // std::cout << "th_b: ";
        // for (float th_bi : th_b) {
        //     std::cout << th_bi << " ";
        // }
        // std::cout << std::endl;
        std::cout << "th_f: ";
        for (float th_fi : th_f) {
            std::cout << th_fi << " ";
        }
        std::cout << std::endl;
        // std::cout << "g_b: ";
        // for (float g_bi : g_b) {
        //     std::cout << g_bi << " ";
        // }
        // std::cout << std::endl;
        // std::cout << "g_t: ";
        // for (float g_ti : g_t) {
        //     std::cout << g_ti << " ";
        // }
        // std::cout << std::endl;
        std::cout << "g_f: ";
        for (float g_fi : g_f) {
            std::cout << g_fi << " ";
        }
        std::cout << std::endl;
    }
};

#endif // BURGER_CONFIG_H
