// burger_config.h
#ifndef BURGER_CONFIG_H
#define BURGER_CONFIG_H

#include <vector>
#include <iostream>

struct BurgerConfig {
    int d;           // Depth of the Bloom filter
    int k;           // Number of regions at the final layer
    long int n;      // Number of positive samples
    float t;         // FPR of the pre-filter
    float f;         // FPR of the final filter
    float th_f;      // Threshold for the final filter
    float g;         // Positive ratio of the final filter

    void print() {
        std::cout << "d: " << d << std::endl;
        std::cout << "k: " << k << std::endl;
        std::cout << "n: " << n << std::endl;
        std::cout << "t: " << t << std::endl;
        std::cout << "f: " << f << std::endl;
        std::cout << "th_f: " << th_f << std::endl;
        std::cout << "g: " << g << std::endl;
    }
};

#endif // BURGER_CONFIG_H
