#ifndef BLOOM_IO_H
#define BLOOM_IO_H

#include <fstream>
#include <iostream>
#include <string>
#include <vector>
#include <filesystem>
#include <exception>
#include <iostream>
#include "bloom.h"

// save and load bloom filter
void save_bloom_filter(const bloomfilter::BloomFilter<uint64_t, false>& b_, std::ofstream& ofs) {
    b_.serialize(ofs);
}

bloomfilter::BloomFilter<uint64_t, false> load_bloom_filter(std::ifstream& ifs) {
    bloomfilter::BloomFilter<uint64_t, false> filter(10, 10);
    filter.deserialize(ifs);
    return filter;
}

#endif // BLOOM_IO_H