#ifndef REDUCE_XGBOOST_MODEL_H
#define REDUCE_XGBOOST_MODEL_H

#include <xgboost/c_api.h>
#include <nlohmann/json.hpp>
#include <fstream>
#include <iostream>
#include <string>
#include <exception>

BoosterHandle reduce_xgboost_model(const BoosterHandle& booster_, int n_estimators) {
    std::string tmp_json_path = "/tmp/xgboost.json";
    std::string reduced_json_path = "/tmp/reduced_xgboost.json";

    // Save the model into a JSON file
    XGBoosterSaveModel(booster_, tmp_json_path.c_str());

    // Load the JSON file
    nlohmann::json xgboost_dict;
    std::ifstream(tmp_json_path) >> xgboost_dict;

    // Modify the number of estimators in the JSON file
    std::cout << "[INFO] Reducing the number of estimators to " << n_estimators << std::endl;
    xgboost_dict["learner"]["gradient_booster"]["model"]["gbtree_model_param"]["num_trees"] = std::to_string(n_estimators);
    xgboost_dict["learner"]["gradient_booster"]["model"]["iteration_indptr"].erase(
        xgboost_dict["learner"]["gradient_booster"]["model"]["iteration_indptr"].begin() + n_estimators + 1,
        xgboost_dict["learner"]["gradient_booster"]["model"]["iteration_indptr"].end()
    );
    xgboost_dict["learner"]["gradient_booster"]["model"]["tree_info"].erase(
        xgboost_dict["learner"]["gradient_booster"]["model"]["tree_info"].begin() + n_estimators,
        xgboost_dict["learner"]["gradient_booster"]["model"]["tree_info"].end()
    );
    xgboost_dict["learner"]["gradient_booster"]["model"]["trees"].erase(
        xgboost_dict["learner"]["gradient_booster"]["model"]["trees"].begin() + n_estimators,
        xgboost_dict["learner"]["gradient_booster"]["model"]["trees"].end()
    );

    // Save the modified JSON to a new file
    std::ofstream(reduced_json_path) << xgboost_dict.dump();

    BoosterHandle reduced_booster;
    XGBoosterCreate(0, 0, &reduced_booster);
    int load_result = XGBoosterLoadModel(reduced_booster, reduced_json_path.c_str());
    if (load_result != 0) {
        throw std::runtime_error("Failed to load model from the temporary file.");
    }

    // Clean up temporary files
    std::remove(tmp_json_path.c_str());
    std::remove(reduced_json_path.c_str());

    return reduced_booster;
}

#endif // REDUCE_XGBOOST_MODEL_H
