#ifndef TREE_H
#define TREE_H

class Node {
public:
    Node(
        float base_weight,
        int left_child,
        int right_child,
        float split_condition,
        int split_index
    ) {
        this->base_weight = base_weight;
        this->left_child = left_child;
        this->right_child = right_child;
        this->split_condition = split_condition;
        this->split_index = split_index;
    }

    float base_weight;
    int left_child;
    int right_child;
    float split_condition;
    int split_index;
};

class Tree {
public:
    Tree(
        std::vector<float> base_weights,
        std::vector<int> left_children,
        std::vector<int> right_children,
        std::vector<float> split_conditions,
        std::vector<int> split_indices
    ) {
        size_t num_nodes = base_weights.size();
        nodes.reserve(num_nodes);
        for (size_t i = 0; i < num_nodes; ++i) {
            nodes.push_back(Node(
                base_weights[i],
                left_children[i],
                right_children[i],
                split_conditions[i],
                split_indices[i]
            ));
        }
    }
    std::vector<Node> nodes;

    float get_leaf_weight(const std::vector<float>& row) {
        int node_index = 0;
        while (true) {
            int left_child = this->nodes[node_index].left_child;
            int right_child = this->nodes[node_index].right_child;
            if (left_child == -1 && right_child == -1) {
                break;
            }
            int split_index = this->nodes[node_index].split_index;
            float split_condition = this->nodes[node_index].split_condition;
            float feature_value = row[split_index];
            node_index = feature_value < split_condition ? left_child : right_child;
        }
        return this->nodes[node_index].base_weight;
    }

    // std::vector<int> categories; // Not Implemented
    // std::vector<int> categories_nodes; // Not Implemented
    // std::vector<int> categories_segments; // Not Implemented
    // std::vector<int> categories_sizes; // Not Implemented
    // std::vector<int> default_left; // Not Implemented
    // std::vector<float> loss_changes; // Not Used for Inference
    // std::vector<int> parents; // Not Used for Inference
    // std::vector<int> split_type; // Not Implemented
    // std::vector<float> sum_hessian; // Not Used for Inference
};

#endif // TREE_H
