import numpy as np
from utils import data_normalize

func_dic = {1: 'np.sin', 2: 'np.cos', 3: 'np.tanh'}
weight_dict  = {1: 1.25, 2: 1.7, 3: 2.2}
noise_weight = 0.3

def synthetic_data(dim, nums, seed, CI=True):
    np.random.seed(seed)
    [seed1, seed2] = np.random.randint(0, 100000, 2)
    Z = np.random.randn(nums, dim)
    X = PNL_process(Z, nums, seed1)
    Y = PNL_process(Z, nums, seed2)
    if CI == False:
        # test Type II error
        T = np.random.randn(nums, 1)
        X += T
        Y += T
    X = data_normalize(X)
    Y = data_normalize(Y)
    Z = data_normalize(Z)
    return X, Y, Z

def PNL_process(Z, nums, seed):
    dims = Z.shape[-1]
    np.random.seed(seed)
    func_id_f_X = np.random.randint(1, 4, dims)
    X = np.zeros((nums, dims))

    # f func
    for i in range(dims):
        func_seed_f = np.random.randint(1, 4)
        if func_id_f_X[i] == 1:
            X[:,i] = eval(func_dic[func_seed_f])(Z[:,i])
        elif func_id_f_X[i] == 2:
            X[:,i] = weight_dict[func_seed_f]*Z[:,i]
        elif func_id_f_X[i] == 3:
            X[:,i] = np.power(Z[:,i], func_seed_f)
        else:
            raise NotImplementedError("not implemented")

    # noise term
    if seed % 2 == 0:
        noise_f_X = noise_weight*np.random.randn(nums)
    else:
        noise_f_X = noise_weight*np.random.uniform(-0.5,0.5, nums)
    X = X.sum(axis=1) + noise_f_X

    # g func
    [func_seed_g, func_id_g_X] = np.random.randint(1, 4, 2)
    if func_id_g_X == 1:
        X = eval(func_dic[func_seed_g])(X)
    elif func_id_g_X == 2:
        X = weight_dict[func_seed_g]*X
    elif func_id_g_X == 3:
        X = np.power(X, func_seed_g)
    else:
        raise NotImplementedError("not implemented")
    X = np.expand_dims(X, axis=1)
    return X




