#!/bin/bash

SIGMOID_BIASES=("False" "True" "False")
FORWARD_TYPES=("exp" "sigmoid" "softmax")
OOD_TRAININGS=("False" "False" "False")
PMA_TYPE=no-residual

for RUN in 0 1 2 3 4
do
    for INDEX in 2
    do
        SIGMOID_BIAS=${SIGMOID_BIASES[INDEX]}
        FORWARD_TYPE=${FORWARD_TYPES[INDEX]}
        OOD_TRAINING=${OOD_TRAININGS[INDEX]}

        CUDA_LAUNCH_BLOCKING=1 PYTHONPATH=/home/ml/ml-baselines/ python toy.py \
            --model proto-mahalanobis \
            --encoder-type diag \
            --pma-type $PMA_TYPE \
            --sigmoid-bias=$SIGMOID_BIAS \
            --ood-training=$OOD_TRAINING \
            --forward-type $FORWARD_TYPE \
            --pma-type $PMA_TYPE \
            --t 1.0 \
            --run $RUN

        for RANK in 1 2 4 8 16 32 64
        do
            PYTHONPATH=/home/ml/ml-baselines/ python toy.py \
                --model proto-mahalanobis \
                --encoder-type low-rank \
                --pma-type $PMA_TYPE \
                --rank $RANK \
                --sigmoid-bias=$SIGMOID_BIAS \
                --ood-training=$OOD_TRAINING \
                --forward-type $FORWARD_TYPE \
                --pma-type $PMA_TYPE \
                --t 1.0 \
                --run $RUN
        done
    done
done

for RUN in 0 1 2 3 4
do
    FORWARD_TYPE="softmax"
    PYTHONPATH=/home/ml/ml-baselines/ python toy.py --model protonet --forward-type $FORWARD_TYPE --run $RUN
    PYTHONPATH=/home/ml/ml-baselines/ python toy.py --model protonet-sn --forward-type $FORWARD_TYPE --run $RUN
    PYTHONPATH=/home/ml/ml-baselines/ python toy.py --model proto-ddu --forward-type $FORWARD_TYPE --run $RUN
    PYTHONPATH=/home/ml/ml-baselines/ python toy.py --model proto-sngp --forward-type $FORWARD_TYPE --run $RUN
done
