import logging
import os

import numpy as np  # type: ignore


def main(path: str) -> None:
    logging.basicConfig(format="%(asctime)s %(levelname)-8s %(message)s", level="INFO", datefmt="%Y-%m-%d %H:%M:%S")

    log = logging.getLogger()
    path = os.path.join(path, "higgs")

    log.info("making permutation")
    perm = np.random.permutation(11000000)

    log.info("loading dataset")
    dataset = np.loadtxt(os.path.join(path, "HIGGS.csv"), delimiter=",")

    log.info("saving the tiny file")
    tiny = dataset[perm[:10000]]
    np.savetxt(os.path.join(path, "TINYHIGGS.npy"), tiny)

    log.info("saving train and test sets")
    train, test = dataset[:-500000], dataset[-500000:]
    np.savetxt(os.path.join(path, "higgs-train.npy"), train)
    np.savetxt(os.path.join(path, "higgs-test.npy"), test)


if __name__ == "__main__":
    main(os.path.join("/home", "datasets"))
