class RunningAverageMeter(object):
    """Computes and stores the average and current value"""
    def __init__(self, momentum: float = 0.99):
        self.momentum = momentum
        self.reset()

    def reset(self) -> None:
        self.val = None
        self.avg = 0.0

    def update(self, val: float) -> None:
        if self.val is None:
            self.avg = val
        else:
            self.avg = self.avg * self.momentum + val * (1 - self.momentum)

        self.val = val  # type: ignore
