# Motion Prior Distillation in Time Reversal Sampling for Generative Inbetweening

### Introduction
**Motion Prior Distillation (MPD).**  
Our key idea is to distill forward motion residuals into the backward path, enforcing a coherent trajectory during time reversal sampling.

---

### 1. Environment Setup
Our source code is based on [generative-models](https://github.com/Stability-AI/generative-models).  
Please clone the repository and place `ours_par.py` and `ours_seq.py` into the directory `scripts/sampling`.  
Follow the environment setup instructions provided in the [generative-models](https://github.com/Stability-AI/generative-models).

---

### 2. Pre-trained Model
Download the Stable Video Diffusion (SVD-XT) weights from [here](https://huggingface.co/stabilityai/stable-video-diffusion-img2vid-xt).  
Update the path to the downloaded model in the `ckpt_path` field of  
`scripts/sampling/configs/svd_xt.yaml`.

---

### 3. Inference: Interpolate Between Two Keyframes
To run inference:

```
python scripts/sampling/ours_par.py     ### Based on TRF
```
or
```
python scripts/sampling/ours_seq.py     ### Based on ViBiD
```
+ The paths to the source frames should be specified using the flags ```input_start_path``` and ```input_end_path```. You can find some example pairs of start and end frames in the `examples/` folder.
+ You can adjust the ```fps_id``` (approximately between 6 and 24) according to the specific use case.