

## Geneval setup

Let `GENEVAL_ROOT` be the root directory of the geneval repo.

Run the following commands in `GENEVAL_ROOT`.

**This guide is only for Hopper and newer GPUs!**

```bash
# Set up repo and virtualenv (uv is only used for python version)
git clone https://github.com/djghosh13/geneval.git .
uv init --bare
vim pyproject.toml  # change python version to `requires-python = "==3.8.10"`
# Make sure python is installed in the geneval repo, not the user home
export UV_PYTHON_INSTALL_DIR="${GENEVAL_ROOT}/python_dist/"
uv sync
uv add pip
source .venv/bin/activate

# Install dependencies in a known order
pip install torch==2.1.2 torchvision==0.16.2 torchaudio==2.1.2 --index-url https://download.pytorch.org/whl/cu121
pip install open-clip-torch==2.26.1
pip install clip-benchmark
pip install -U openmim
pip install einops
pip install lightning
pip install diffusers transformers
pip install tomli
pip install platformdirs

# Need setuptools AND wheel to build the later packages
# This might yield errors; just ignore them as long as the packages are ultimately installed
pip install -U setuptools wheel

# Install the packages that require manual compilation; this might take a while
## mmcv (and mmengine)
git clone https://github.com/open-mmlab/mmcv.git
pushd mmcv
git checkout 1.x
MMCV_WITH_OPS=1 MMCV_CUDA_ARGS="-arch=sm_90" pip install -v -e .
popd

## mmdet
git clone https://github.com/open-mmlab/mmdetection.git
pushd mmdetection
git checkout 2.x
MMCV_CUDA_ARGS="-arch=sm_90" pip install -v -e . --no-build-isolation
popd

# Download model weights
./evaluation/download_models.sh "./model_weights"
```

Now, running the geneval grading script is done via

```bash
UV_PYTHON_INSTALL_DIR="${GENEVAL_ROOT}/python_dist/" uv run --project "${GENEVAL_ROOT}" \
    -m divergent_memories.evals.grade_geneval \
        --input /path/to/input.jsonl \
        --output /path/to/output.jsonl
```
