
# DrivAerStarBenchmarking Project Description  

## Project Overview  
The DrivAerStarBenchmarking project is a benchmarking initiative for the **DrivAerStar dataset**, designed to train and evaluate deep learning models (such as the Transolver model) on irregular grid data. The project uses configuration files to flexibly control model parameters, data loading, and training processes, with support for GPU-accelerated training.  


## Environment Setup  
### 1. Dependency Installation  


```bash  
pip install -r requirements.txt  
```  

Recommended to use python>=3.10.

### 2. Additional Dependencies (If Installation Fails)  
If missing libraries (e.g., PyTorch components, mesh processing libraries) are encountered, manually install them or modify the `requirements.txt` file.  


## Project Structure  
```  
.  
├── configs/                # Configuration files directory  
│   └── Transolver/         # Specific configurations  
│       └── Transolver_1V_400.yaml # Model configuration  
├── data_module/            # Dataset code directory  
│   └── subset/             # Subset (small dataset)  
│       └── DrivAerStar_488.py    # Dataset code  
├── networks/               # deep networks
│   └── Transolver/         # code for every networks
│   └── ...
├── main_train_val_test.py        # Training entry script  
└── requirements.txt        # Dependency list  
```  


## Usage Guide  
### Execution  
1. Train and validate the model  
   ```bash  
   python main_train.py --config-path configs/Transolver/Transolver_1V_400.yaml
   ```  

2. predict 
   ```bash  
   python main_predict.py \  
        --config-path configs/Transolver/Transolver_1V_400.yaml \  
        --load-ckpt-path logs/checkpoints/epoch=38-step=39.ckpt  
   ```  

### 2. Configuration File Explanation (`Transolver_Irregular_Mesh.yaml` Example)  
#### Core Parameter Groups  
```yaml  
Seed: 42                    # Random seed for experiment reproducibility  
Data:  
  args:  
    batch_size: 8           # Training batch size (adjust based on GPU memory)  
    data_dir: "/dir/to/DrivAerStar/vtk/"  # Dataset path (replace with local path)  
    val_batch_size: 1       # Validation batch size  
    num_train: 50           # Number of training samples  
    num_val: 10             # Number of validation samples  
    num_test: 10            # Number of test samples  
    no_cache: False         # Disable data caching (keep False for first run to accelerate subsequent training)  
    data_cache_file: "./dataset/cache_DrivAerStar_488.pt"  # Cache file path  
  type: DrivAerStar_488     # Dataset type (must match the code)  
Trainer:  
  args:  
    accelerator: gpu        # Acceleration device (gpu/cpu)  
    devices: 1              # Number of GPUs to use  
    max_epochs: 500         # Maximum number of training epochs  
load_ckpt: null             # Path to pre-trained model (set to null if none)  
network:  
  args:  
    lr: 0.001               # Learning rate  
    space_dim: 7            # Input spatial dimension (adjust based on data features)  
    out_dim: 4              # Output dimension (defined by the task)  
    weight_decay: 0.0001    # Weight decay  
    n_hidden: 64            # Hidden layer dimension  
    n_layers: 4             # Number of network layers  
    n_heads: 4              # Number of attention heads (for models with attention)  
    max_grad_norm: 0.1      # Gradient clipping threshold (prevents gradient explosion)  
    downsample: 5           # Downsampling factor (adjust based on grid resolution)  
    mlp_ratio: 1            # MLP layer ratio  
    dropout: 0.0            # Dropout rate  
    ntrain: 50              # Number of training samples (must match Data.args.num_train)  
    unified_pos: 0          # Unified position encoding (0/1, model-specific parameter)  
    ref: 8                  # Number of reference frames (parameter for temporal tasks)  
    slice_num: 16           # Number of slices (mesh processing parameter)  
    eval: 0                 #  
  type: Transolver_Irregular_Mesh  # Model type (must match the model class in the code)  
```  


## Parameter Replacement Notes  
1. **Data Path**: Replace `Data.args.data_dir` with the local path to the DrivAerStar dataset’s VTK files (e.g., `"/path/to/DrivAerStar/****.vtk"`).  
2. **Batch Size and GPU Memory**: Adjust `Data.args.batch_size` and `Trainer.args.devices` based on GPU memory (e.g., reduce `batch_size` if memory is insufficient; currently only supports 1 GPU).  
3. **Model Hyperparameters**: Tune parameters under `network.args` (e.g., `lr`, `n_hidden`, `n_layers`) based on experimental needs. Start with default values for debugging.  


## Notes  
1. **Data Caching**: The dataset is automatically cached to `data_cache_file` during the first training run, accelerating subsequent loads. Delete the cache file or set `no_cache: True` if the data is updated.  
2. **Model Definition**: `network.type` must match the actual model class name in the code (e.g., `Transolver_Irregular_Mesh` corresponds to the class in `models/Transolver_Irregular_Mesh.py`).  


## Contributions and Feedback  
To add new models or datasets, create new configuration files in the `configs/` directory and modify the model loading logic in `main_train.py`. For issues, use the project’s Issues section or directly modify dependency files.