"""
Defines an abstract base class for all conversation-related models.
"""

from abc import ABC, abstractmethod
from typing import Any, List, Dict


class BaseModel(ABC):
    """
    An abstract base class representing a model for generating responses
    in a conversation setting. Concrete implementations might wrap around
    neural network models, APIs, or rule-based systems.
    """

    def __init__(self, model_path: str):
        self.model_path = model_path

    @abstractmethod
    def generate(self, prompt: str, **kwargs: Any) -> str:
        """
        Generate a response string based on the provided prompt.

        :param prompt: The input text prompt or query for generating a response.
        :type prompt: str
        :return: A generated response string.
        :rtype: str
        """
        raise NotImplementedError("This method must be implemented by the subclass")

    #@abstractmethod
    def chat(self, messages: List[Dict[str, str]], **kwargs):
        raise NotImplementedError("This method must be implemented by the subclass")
