function [delta_uni, delta_exp, alpha_exp] = pickQuantParams(X, B)
  % Compute the uniform- and exponential-spacing quant steps for B bits.
  [~,d] = size(X);
  R     = 2;          % dynamic range
  delta_uni = R/(2^(B-1)-1);           % uniform step
  alpha_exp = (B + log(2*d*log(2)))*2^(-B-1);  % mantissa‐growth factor
  delta_exp = sqrt(2^(-B-1)/d*log(2));
  % Npos  = 2^(B-1);                 
  % delta_exp = (alpha_exp*R)/((1+alpha_exp)^Npos - 1);  % so that q_Npos = R                     
end

% 
% function [delta_uni, delta_exp, alpha_exp] = pickQuantParams(X, B)
%   % Compute the uniform- and exponential-spacing quant steps for B bits.
%   [~,d] = size(X);
%   R     = 2;          % dynamic range
%   delta_uni = R/(2^(B-1)-1);           % uniform step
%   alpha_exp = (2*B + log(8*d*log(2)))*2^(-B);  % mantissa‐growth factor
%   delta_exp = sqrt(2^(-(2*B-1))/d*log(2));
%   % Npos  = 2^(B-1);                 
%   % delta_exp = (alpha_exp*R)/((1+alpha_exp)^Npos - 1);  % so that q_Npos = R                     
% end