function sr = stochasticRound(x, delta)
% stochasticRound performs stochastic rounding on its input x to the nearest multiples
% of delta. This simulates low-precision arithmetic.
%
% For each element in x, let:
%    lower = floor(x/delta)*delta,  upper = lower + delta.
% Then round to lower with probability (upper - x)/delta, and to upper with probability (x - lower)/delta.
%
% INPUTS:
%   x     - Input number, vector, or matrix.
%   delta - The quantization resolution.
%
% OUTPUT:
%   sr    - The stochastically rounded value(s).

lower = floor(x / delta) * delta;
upper = lower + delta;
% Compute probability of rounding up
prob = (x - lower) / delta;
% Generate uniform random numbers of the same size as x
randMat = rand(size(x));
% Choose lower if random number is greater than prob, otherwise upper.
sr = lower;
sr(randMat < prob) = upper(randMat < prob);
end
