# First-Order Minimax Bilevel Optimization: New Algorithms and Applications

## Requirements
```
higher==0.2.1
learn2learn==0.1.7
libauc==1.3.0
matplotlib==3.7.2
numpy==1.24.3
opencv_python==4.7.0.72
pandas==2.0.1
Pillow==9.4.0
Pillow==10.2.0
scikit_learn==1.3.0
torch==1.7.0
torch_geometric==2.4.0
torch_scatter==2.1.2
torchvision==0.8.0
torchviz==0.0.2
tqdm==4.65.0
```
To install these requirements, run the following command.
```bash
pip install -r requirement.txt
```
Note that when running FOSL_graph.py, a newer version of pytorch is needed (torch==1.12.1).
## Dataset

We use CIFAR100, CelebA, CheXpert and OGBG-MolPCBA for FOSL training on deep AUC maximization task, and Mini-ImageNet and Tiered-ImageNet for MemCS training on robust meta-learning task. Below is the file directory of datasets.

### CelebA
```
└── celeba
  ├── img_align_celeba
  ├── celeba_attr_test.csv
  ├── celeba_attr_train.csv
  ├── celeba_attr_val.csv
  ├── list_attr_celeba.csv
  ├── list_bbox_celeba.csv
  ├── list_eval_partition.csv
  ├── list_landmarks_align_celeba.csv
```

### CheXpert
```
└── CheXpert-v1.0-small
  ├── train
  ├── valid
  ├── train.csv
  ├── valid.csv
```

### OGBG-MolPCBA
```
└── ogb
  ├── mapping
  ├── ogbg_molpcba
  ├── processed
  ├── raw
  ├── split
  ├── obgb-master.csv
```

### Mini-ImageNet

```
└── mini-imagenet
  ├── mini-imagenet-cache-train.pkl
  ├── mini-imagenet-cache-validation.pkl
  ├── mini-imagenet-cache-test.pkl
  ├── mini-imagenet-bookkeeping-train.pkl
  ├── mini-imagenet-bookkeeping-test.pkl
  ├── mini-imagenet-bookkeeping-validation.pkl
```

### Tiered-ImageNet

```
└── tiered_imagenet
  ├── class_names.txt
  ├── synsets.txt
  ├── test_images_png.pkl
  ├── test_labels.pkl
  ├── train_images_png.pkl
  ├── train_labels.pkl
  ├── val_images_png.pkl
  └── val_labels.pkl
```

## Training

### FOSL

Training on CIFAR100:
```bash
python FOSL.py --gpuid 0 --dataset cifar100 -e 2000 --SEED 123 --lambda_value 5 --lr 0.1 --beta 0.9 --beta_ct 0.9 --num_workers 2 --data_dir $your_data_dir$ --save_dir  $your_save_dir$
```

Training on CelebA:
```bash
python FOSL.py --gpuid 0 --dataset celeba -e 40 --SEED 123 --lambda_value 2 --lr 0.1 --beta 0.9 --beta_ct 0.9 --num_workers 2 --data_dir $your_data_dir$ --save_dir  $your_save_dir$
```

Training on CheXpert:
```bash
python FOSL.py --gpuid 0 --dataset chexpert -e 6 --SEED 123 --lambda_value 6 --lr 0.1 --beta 0.9 --beta_ct 0.9 --num_workers 2 --data_dir $your_data_dir$ --save_dir  $your_save_dir$
```

Training on OGBG-MolPCBA:
```bash
python FOSL_graph.py --gpuid 0 --epochs 100 --SEED 123 --lambda_value 6 --lr 0.1 --beta 0.9 --beta_ct 0.9 --num_workers 2 --gnn gin --data_dir $your_data_dir$ --save_dir  $your_save_dir$
```

### MemCS

Training on Mini-ImageNet
```bash
python MemCS.py --lambda_value 3 --gpuid 0 --k 12 --training_steps 3000 --inner_step 15 --lr_inner 0.02 --lr_v 0.1 --lr_outer 0.2 --lr_gamma 0.1 --data_dir $your_data_dir$ --save_dir $your_save_dir$ --scale_gamma 1 --gamma_scale 100 --dataset mini
```

Training on Tiered-ImageNet
```bash
python MemCS.py --lambda_value 3 --gpuid 0 --k 12 --training_steps 3000 --inner_step 15 --lr_inner 0.02 --lr_v 0.1 --lr_outer 0.2 --lr_gamma 0.1 --data_dir $your_data_dir$ --save_dir $your_save_dir$ --scale_gamma 1 --gamma_scale 100 --dataset tiered
```

Training with noisy settings
```bash
python MemCS.py --lambda_value 3 --gpuid 0 --k 12 --training_steps 3000 --inner_step 15 --lr_inner 0.02 --lr_v 0.1 --lr_outer 0.2 --lr_gamma 0.1 --data_dir $your_data_dir$ --save_dir $your_save_dir$ --scale_gamma 1 --gamma_scale 100 --dataset tiered --flip 1 --flip_thresh 0.6
```

```bash
python MemCS.py --lambda_value 3 --gpuid 0 --k 12 --training_steps 3000 --inner_step 15 --lr_inner 0.02 --lr_v 0.1 --lr_outer 0.2 --lr_gamma 0.1 --data_dir $your_data_dir$ --save_dir $your_save_dir$ --scale_gamma 1 --gamma_scale 100 --dataset tiered --rand 1
```