# Ethical Dilemmas in Gain-of-Function Research: A Case Study of H5N1 Influenza Virus Investigations

* 1191200221 数媒2002 陈云豪

# 1. History of Human's Efforts to Conterback Flu

Throughout human history, our battle with viruses has been persistent. It wasn't until the early 20th century that scientists began to truly understand viruses. These entities, distinct from bacteria and capable of passing through bacterial filters, are composed of simple nucleic acids encased in protein shells and replicate only within host cells. The 1918 Spanish Flu (H1N1), causing 50 million deaths globally, remained largely a mystery at the time, with scientists speculating bacterial causes due to the dominant bacteriological theories of Pasteur and Koch. Over the last century, three major flu outbreaks have occurred: the 1957 Asian Flu (H2N2), the 1968 Hong Kong Flu, and the 2009 H1N1 pandemic in the USA. These pandemics had profound impacts on human health and socio-economic structures, leading to significant social panic. Scholars have likened these impacts to a "viral effect," akin to the butterfly effect, posing unprecedented challenges to humanity.

With the advancement of modern biotechnology, our understanding of viruses like influenza has significantly improved. However, seasonal flu and various animal flu subtypes continue to pose threats to public health. To date, apart from vaccines, there are no highly effective antiviral drugs. The rapid evolution and mutation of viruses are astounding. Research on viruses typically involves studying the structure, biological characteristics, and epidemiological data of identified pathogens. Some scientists engage in "pre-emptive" intervention, employing DNA recombination techniques to create new mutant strains, altering the virus's host or increasing its pathogenicity. This approach, known as "Gain-of-Function Research," aims to better inform public health and prevention efforts but has sparked considerable controversy around biosafety.

# 2. Course of Event

The chronology of events involves Professor Yoshihiro Kawaoka from the University of Wisconsin-Madison, a virologist dedicated to the study of influenza and Ebola viruses, also serving as a professor in the Department of Microbiology and Immunology at the University of Tokyo. His research has significantly contributed to understanding the pathogenic mechanisms of influenza viruses, cross-species transmission, antigen studies, and vaccine development, although not without controversy. In 2013, Kawaoka was elected a foreign associate of the National Academy of Sciences. Beginning in 2008, with funding from the National Institutes of Health (NIH), Kawaoka conducted research related to the molecular characteristics of H5N1 influenza virus transmission.

On August 31, 2011, Kawaoka submitted a paper to Nature, revealing genetic modifications made to the virus to increase its transmissibility. He replaced the H5 portion of the genetically modified H5N1 influenza virus with the H1 portion from the 2009 H1N1 strain, creating a variant that could be transmitted through respiratory droplets in ferrets. This represents a typical Gain-of-Function Research, aimed at understanding the virus's evolutionary mechanism, enhancing its virulence and transmissibility.

Simultaneously, Dr. Ron A.M. Fouchier of Erasmus MC, Netherlands, conducted mutation-inducing research on the H5N1 virus, submitting a paper to Science on August 30, 2011, discussing the air transmission of the H5N1 avian influenza virus. The study indicated that partial genetic modification of H5N1 could significantly increase its transmissibility among mammals like ferrets. By converging five naturally occurring mutations through genetic engineering, the accelerated evolution of the H5N1 virus was achievable. Upon receiving these two papers, the editors quickly forwarded them to the National Science Advisory Board for Biosecurity (NSABB) due to the potential risks associated with publicizing the research results and data.

Following the 9/11 attacks and subsequent anthrax mail attacks, there was increased concern about the malicious application of life science research. The 2004 report "Biotechnology Research in an Age of Terrorism" called for the careful review of dual-use research, clarifying the significance of some research findings for terrorism. The report also suggested that the government take action, establish national biosafety advisory committees, and implement appropriate biosafety measures. Consequently, the U.S. government initiated various measures against bioterrorism threats, including the regulation of dual-use research in life sciences and biotechnology, leading to the establishment of the NSABB. This committee, serving the Department of Health and Human Services and subordinate to the NIH, comprises no more than 25 voting members. Its responsibilities include providing guidance and advice for the biosafety supervision of dual-use research in life sciences, offering education, training, and development suggestions for scientists, laboratory personnel, students, and trainees in related disciplines, advising on the publication and public communication of dual-use research findings, proposing strategies to encourage international community involvement in managing dual-use research in life sciences, and providing policy suggestions for the implementation, communication, and supervision of dual-use research and its findings.

Despite the potential public health significance of these two H5N1 studies in improving surveillance, prediction, prevention, diagnosis, and treatment of influenza pandemics, the undeniable risk of misuse existed. Therefore, all NSABB members participated in discussions about these studies. After five and a half weeks of challenging deliberations, analyzing the data in both papers, and weighing the risks and benefits of publishing the information, the NSABB recommended on November 21, 2011, that Nature and Science magazines re-edit the two papers. The suggestion was to publish key conclusions, omitting data and methods, sharing them only with trustworthy experts and institutions. This marked the first time since its establishment in 2004 that the NSABB made such a restrictive suggestion. The decision sparked numerous controversies, with some viewing it as academic censorship and an infringement on scientific freedom, while others argued that the dual-use nature of science necessitates certain compromises.

# 3. Debate

The controversy surrounding the NSABB's opinions on Gain-of-Function research sparked reconsideration of the research's value. Supporters argue that the five gene mutations studied by Fouchier were found in natural H5N1, aiding early pandemic warnings. Kawaoka's research contributed to understanding viral transmission and evolution. However, risks, like laboratory leaks, raised concerns, with some experts advocating against such research due to potential misuse, including bioterrorism.

On January 20, 2012, NIH released a statement regarding NSABB's review of H5N1 research, suggesting withholding full publication of the manuscripts to prevent misuse. Consequently, Health Department provided NSABB's non-mandatory recommendations to Kawaoka, Fouchier, and journal editors.

Simultaneously, researchers, including Kawaoka and Fouchier, announced a voluntary 60-day pause on H5N1 research, awaiting international discussions on handling the research responsibly. This pause applied to experiments enhancing the transmissibility of highly pathogenic avian influenza in mammals.

The controversy reached the public, raising questions about the creation, storage, and potential misuse of high-risk viruses. WHO held a technical consultation in February 2012 to clarify facts and discuss biosafety concerns related to the research. Participants reviewed various aspects of the research, including laboratory practices and funding oversight. The meeting concluded that gene-modification data were valuable for improving public and animal health monitoring but needed to be balanced against the potential for misuse.

WHO later held another meeting, advocating for the publication of the research without redaction and discussing the need for effective communication strategies to enhance public understanding of H5N1 research. They also debated on issues like virus storage, biosafety standards, and future research permissions. It was agreed that laboratory conditions for H5N1 research should be improved and a comprehensive monitoring system established.

On March 29 and 30, 2012, the NSABB held its second meeting to review previous meeting information and international opinions, reevaluate the publication recommendations, and suggested full publication of the two papers. The NSABB also released "United States Government Policy for Oversight of Life Sciences Dual Use Research of Concern", stating that the purpose of this policy is to periodically review US government-funded or conducted research on certain highly pathogenic microorganisms to reduce risks, gather necessary information, and safeguard the interests of life sciences research while minimizing the risks of misuse of knowledge, information, products, or technologies arising from such research. This policy supplements existing regulations and policies of the US government regarding the possession and handling of pathogenic microorganisms and provides guidance to researchers, national security officials, and global health experts.

On May 1, 2012, the National Academy of Sciences' Committee on Science, Technology, and Law, in conjunction with the Committee on Life Sciences, held a one-day public workshop called the Forum on Microbial Threats. The purpose of the workshop was to "explore the full range of intervention points from research conceptualization to publication" and discuss current regulations and oversight of research, as well as consider the establishment and implementation of new mechanisms.

On June 22, 2012, Yoshihiro Kawaoka's paper titled "Experimental adaptation of an influenza H5 HA confers respiratory droplet transmission to a reassortant H5 HA/H1N1 virus" was published in Nature. The research emphasized the need to be prepared for a potential pandemic caused by H5 HA influenza viruses. This knowledge would enable researchers to monitor the pandemic potential of circulating or newly emerging variants, focus efforts on these critically important molecular changes subgroups of viruses, stockpile antiviral complexes in regions where the virus is circulating, and initiate vaccine production and large-scale manufacturing before a pandemic occurs. Additionally, Yoshihiro Kawaoka's paper "The Possible Interspecies Transmission of A/H5N1 Influenza Virus via Respiratory Droplets in the Mammalian Host" was published in Science on the same day, suggesting that the A/H5N1 influenza virus could potentially undergo only five amino acid substitutions or four reassortments to achieve respiratory droplet transmission between mammals, posing a pandemic threat. Two of these substitutions were common in A/H5N1 viruses , and some viruses may require only three additional substitutions for respiratory droplet transmission between mammals. Therefore, this study investigated the potential threat of such viruses evolving in nature by using a mathematical model of viral evolution within the host to study the probabilities of increasing or decreasing the remaining substitutions after virus infection in mammalian hosts.

With the publication of these papers, the tension surrounding H5N1 research gradually eased, and Yoshihiro Kawaoka and Fouchier proposed in October 2012 to lift the temporary ban on research on A/H5N1 influenza and resume work since natural mutations had been observed, posing new threats to humans. This race between laboratory and naturally occurring viruses resumed with the approval of governments and relevant agencies. On February 1, 2013, Yoshihiro Kawaoka and others officially declared the resumption of research, stating that research on A/H5N1 influenza virus transmission was crucial for pandemic prevention and understanding the virus's adaptation to mammals. However, scientists should not conduct similar research in laboratories lacking the necessary conditions and regulatory systems.

On July 3, 2014, Yoshihiro Kawaoka caused significant controversy again by creating a "super H1N1 virus" to analyze genetic changes in H1N1 and bypass key steps of the human immune system. However, Yoshihiro Kawaoka's research on H1N1 and H5N5 influenza viruses continued, and over a hundred papers have been published from 2014 to the present. Although it has been difficult to retrieve research outcomes after 2018. Fouchier also continues his research in the field of respiratory viruses, avian influenza viruses, coronaviruses, and others, with approximately one hundred papers published from 2013 to the present.

# 4. Case Analysis

Gain-of-Function(GoF) research, particularly in virology, involves manipulating viruses to better understand their mechanisms, including their potential to cause pandemics. While this research is crucial for preventing and controlling future outbreaks, it raises significant ethical concerns, given its dual-use nature and the possibility of creating more virulent or transmissible viral strains. Key ethical concerns include:

1. **Risk vs. Benefit:** The balance between the potential public health benefits and risks in GoF research is complex. On the positive side, this research can lead to significant advancements in understanding viral mechanisms, aiding in vaccine development and epidemic control. However, the risks are substantial, including the possibility of accidental release of a more virulent virus or misuse of research data to create biological weapons. Ethical decision-making in this context requires a careful evaluation of the likelihood and magnitude of both benefits and risks, and the implementation of stringent safety protocols to minimize potential harm.
2. **Dual-use Dilemma:** GoF research embodies a classic 'dual-use' dilemma, where scientific discoveries intended for the betterment of humanity can also be used for harmful purposes. This raises significant ethical concerns regarding the responsibility of researchers and institutions in ensuring that their work does not fall into the wrong hands. It also brings into focus the need for comprehensive international agreements and oversight mechanisms to regulate research and prevent misuse for bioterrorism or other malevolent purposes.
3. **Transparency vs. Security:** The debate between transparency and security in GoF research is a contentious issue. Advocates for transparency argue that open sharing of information accelerates scientific progress and fosters collaboration, while those advocating for security emphasize the need to restrict access to sensitive information to prevent its misuse. Striking a balance requires a nuanced approach, taking into account factors like the level of detail in publications, the potential for misuse, and the benefits of collaborative research.
4. **Regulatory and Oversight Challenges:** Effective regulation and oversight of GoF research are crucial to ensuring its safe conduct. However, existing regulatory frameworks may struggle to keep pace with the rapid advancements in biotechnology. Challenges include determining the appropriate level of oversight, ensuring compliance without hampering scientific innovation, and adapting regulations to emerging technologies and methodologies.
5. **Global Cooperation and Standard Setting:** In the face of global pandemic threats, international cooperation in GoF research is essential. This involves not only sharing research findings but also harmonizing safety standards and protocols across different countries and research institutions. Ethical considerations include ensuring equitable access to research data, respecting diverse cultural and ethical perspectives, and collaborating on global risk assessment and management strategies.
6. **Ethical Responsibility of Researchers:** Researchers engaged in GoF studies must navigate a complex ethical landscape, balancing the pursuit of scientific knowledge with the potential risks to public health. This responsibility extends beyond adhering to safety protocols; it includes considering the broader societal implications of their work, engaging with ethical debates, and actively participating in risk assessment and management discussions.
7. **Informed Consent and Public Engagement:** Engaging the public in discussions about GoF research is crucial for maintaining public trust and ensuring societal alignment with scientific endeavors. This involves transparent communication about the benefits and risks, addressing public concerns, and involving laypeople in decision-making processes where appropriate. The concept of informed consent, typically applied to individual research participants, can be extended to a broader societal context in the case of GoF research.
8. **Precautionary Principle:** The precautionary principle advocates for erring on the side of caution in research that could potentially pose a threat to public health. In the context of GoF research, this could mean delaying, modifying, or even halting certain studies when the risks are not fully understood or cannot be adequately managed. This approach emphasizes risk prevention and careful deliberation before proceeding with potentially hazardous research.
9. **Global Governance:** Effective global governance of GoF research is vital for managing biosecurity risks. This requires international collaboration in establishing and enforcing research guidelines, sharing best practices, and ensuring that safety standards are uniformly applied. Challenges include reconciling differences in regulatory approaches, fostering international cooperation, and ensuring compliance by all parties involved.
10. **Ethical Education for Scientists:** The importance of ethical education for scientists, especially those engaged in dual-use research, cannot be overstated. Ethical training should be integrated into scientific education, emphasizing critical thinking, societal implications of research, and responsible conduct. This education should also address the specific challenges and responsibilities associated with GoF research, fostering a culture of ethical awareness and decision-making among scientists.
11. **Role of Media and Communication:** The way scientific findings, particularly those with potential risks, are communicated to the public is crucial. Media outlets have a responsibility to report on GoF research responsibly, avoiding sensationalism and misinformation. Accurate and balanced reporting is essential for educating the public about the complexities of the research and its implications, fostering an informed and rational public discourse.
12. **Ethics of Publication:** Journals and publishers face ethical challenges in deciding whether and how to publish sensitive GoF research findings. The dilemma lies in balancing the need for open scientific communication, which promotes collaboration and progress, against the risk of providing information that could be misused. Publishers must navigate issues such as peer review, redaction of sensitive details, and compliance with regulatory guidelines, while upholding the principles of academic freedom and scientific advancement.
13. **Intellectual Property Rights vs. Public Health:** Intellectual property (IP) rights in the context of GoF research raise ethical questions about the balance between protecting the rights of researchers and institutions, and ensuring public access to scientific discoveries, especially in global health contexts. The tension between profit motives and the imperative to address public health needs is particularly pronounced in situations where access to vaccines or treatments may be restricted due to IP rights, raising concerns about equity and global health justice.
14. **Monitoring and Whistleblowing:** Establishing effective monitoring systems for GoF research and creating an environment where ethical concerns can be freely raised are essential components of research governance. This includes implementing mechanisms for ongoing surveillance of research activities, ensuring compliance with ethical standards, and protecting whistleblowers who expose unethical practices or safety violations.
15. **Ethical Decision-Making Frameworks:** Applying structured ethical frameworks, such as consequentialism, deontology, or virtue ethics, can guide decision-making in complex GoF research scenarios. These frameworks provide a systematic way to evaluate the ethical dimensions of research, considering factors such as the consequences of actions, adherence to moral principles, and the cultivation of virtuous qualities in researchers.
16. **Risk Communication and Education:** Developing clear and effective communication strategies is crucial for informing not just the scientific community, but also policymakers, stakeholders, and the general public about the risks and benefits associated with GoF research. This involves crafting messages that are accessible, transparent, and responsive to the concerns and values of diverse audiences.
17. **Future Implications:** Considering the long-term implications of GoF research is essential. Decisions made today can have far-reaching effects on future scientific practices, public health, and public trust in science. This forward-looking approach requires careful consideration of how current research might influence future scientific capabilities, ethical norms, and societal attitudes towards science.
18. **Societal Trust in Science:** The way GoF research is conducted and communicated plays a significant role in shaping public trust in science. Maintaining this trust requires transparency, ethical conduct, and effective communication strategies that accurately convey the risks and benefits of the research.
19. **Evolution of Ethical Standards:** Ethical standards in science are not static; they evolve alongside societal values and technological advancements. Continuous dialogue, reflection, and adaptation of these standards are essential in responding to new ethical challenges posed by scientific progress.
20. **Emergency Preparedness and Response:** GoF research highlights the need for robust emergency preparedness and response strategies. This involves developing comprehensive plans to address potential outbreaks resulting from research activities, including rapid response capabilities and contingency planning.
21. **Interdisciplinary Collaboration:** Involving experts from diverse fields, such as ethicists, sociologists, and public policy experts, in GoF research decision-making processes ensures a more comprehensive and ethically sound approach. This collaboration can provide valuable insights and perspectives that are not always evident within the scientific community alone.
22. **Ethical Leadership in Science:** Ethical leadership in the scientific community is about setting standards, mentoring future researchers, and fostering an environment where ethical considerations are integral to the research process. Leaders play a key role in shaping the ethical culture of their institutions and the wider scientific community.

Each aspect, from the responsibility of individual researchers to global governance and public communication, contributes to a complex ethical landscape. Navigating this landscape requires ongoing dialogue, interdisciplinary collaboration, and a commitment to balancing scientific advancement with public safety and ethical integrity.

# 5. Conclusion and Inspiration

**Conclusion:** The debate surrounding H5N1 Gain-of-Function (GoF) research exemplifies the complex interplay between scientific progress and ethical responsibility. This research, aimed at enhancing our understanding of flu viruses, poses significant risks, including the potential creation of more dangerous pathogens. This dilemma accentuates the need for comprehensive ethical frameworks, transparent public discourse, and rigorous regulatory oversight in scientific endeavors, particularly in areas with dual-use potential.

The ethical quandaries inherent in GoF research are multifaceted. Firstly, the risk-benefit analysis is paramount. On one hand, GoF research offers invaluable insights into viral mechanisms, potentially leading to groundbreaking developments in vaccine technology and pandemic preparedness. On the other hand, the risks associated with creating potentially more transmissible or deadly virus strains cannot be understated. This risk is not merely theoretical, as seen in past incidents where laboratory strains of viruses have escaped containment, albeit usually less dangerous strains.

The dual-use nature of GoF research further complicates the ethical landscape. While the primary goal is to advance scientific knowledge for public good, the same research could be misappropriated for harmful purposes, such as biological warfare or bioterrorism. This possibility necessitates a proactive approach to biosecurity, balancing scientific openness with the need to safeguard against misuse.

Transparency and public engagement are crucial in navigating these ethical waters. The scientific community must engage in open and honest dialogue with the public, policymakers, and international bodies. This communication should not only involve the dissemination of research findings but also an explanation of the risks involved and the measures taken to mitigate them. Public trust in science, particularly in GoF research, hinges on this transparency.

Regulatory and oversight challenges are inherent in GoF research. The role of bodies like the National Science Advisory Board for Biosecurity (NSABB) is critical, yet they face the challenge of developing guidelines that ensure safety without impeding scientific progress. The regulatory framework must be dynamic, capable of adapting to the fast-paced advancements in biotechnology and the evolving nature of biosecurity threats.

International cooperation is imperative, given the global implications of GoF research. Pandemics do not respect national borders; hence, a collaborative approach to biosecurity and ethical standards is necessary. This cooperation should extend beyond governments to include international organizations, research institutions, and scientists across the globe.

Ethical responsibility lies at the core of GoF research. Researchers must be cognizant of the broader implications of their work, adhering to ethical principles and stringent safety protocols. This responsibility extends to considering the potential long-term effects of their research on public health and the environment.

The precautionary principle advocates for a conservative approach, especially in situations where the risks are not fully understood. In the context of GoF research, this may mean erring on the side of caution, implementing stringent safety measures, and, in some cases, pausing certain lines of research until a clearer understanding of the risks is obtained.

Global governance of GoF research is a pressing issue. Developing and enforcing international standards and protocols is crucial for ensuring uniform safety and ethical practices. This requires a concerted effort from nations, international bodies, and the scientific community to establish common ground on biosecurity measures and ethical guidelines.

Ethical education for scientists is an integral component. Researchers involved in GoF and other dual-use research areas must be trained not only in technical skills but also in bioethics. This training should encompass the understanding of ethical principles, biosecurity risks, and the societal implications of their work.

The role of the media in communicating scientific findings to the public is more important than ever. Accurate and responsible reporting is essential to inform public understanding and avoid sensationalism, which can lead to misinformation and fear.

Ethical considerations in the publication of sensitive scientific information are critical. Publishers and journals must balance the scientific community's need for open access to data with the potential risks associated with the dissemination of sensitive information.

Intellectual property rights and public health often find themselves at odds in GoF research. The ethical implications of owning proprietary technology or findings in the pharmaceutical industry, particularly in the context of global health crises, raise questions about access to life-saving technologies and treatments, especially in resource-limited settings.

Monitoring and whistleblowing mechanisms within research institutions are crucial for maintaining ethical standards. Researchers should be able to voice concerns about unethical practices without fear of retribution, and there should be systems in place to address these concerns promptly and effectively.

Ethical decision-making frameworks provide a structured approach to navigating the complex ethical landscape of GoF research. These frameworks help researchers and policymakers evaluate the moral implications of their decisions, considering potential outcomes, societal impact, and ethical duties.

Risk communication and education are essential, especially in fields like GoF research, where the risks are significant and often difficult to understand for non-specialists. Developing effective communication strategies to inform the public, policymakers, and the scientific community about these risks is crucial for informed decision-making.

The future implications of GoF research are far-reaching. Decisions made today will shape the trajectory of scientific research, influence public health policy, and affect public trust in science for years to come. As such, it's imperative to consider the long-term consequences of this research, including how it will impact future scientific practices and societal perceptions of science.

Societal trust in science is a cornerstone of effective scientific research and public health policy. The way GoF research is conducted, regulated, and communicated plays a significant role in shaping this trust. Maintaining public trust requires a commitment to transparency, ethical conduct, and effective communication strategies.

The evolution of ethical standards in science is an ongoing process. As scientific knowledge advances and societal values change, ethical standards must evolve to address new challenges and ensure that scientific research continues to serve the public good.

Emergency preparedness and response are critical in the context of GoF research. Robust strategies and plans must be in place to address potential outbreaks or accidents resulting from research activities. This involves not only scientific and medical responses but also coordinated efforts with public health authorities, governments, and international organizations.

Interdisciplinary collaboration is key to addressing the ethical challenges of GoF research. Involving experts from various fields, including ethics, sociology, law, and public policy, ensures a more holistic approach to decision-making and helps to identify and address potential ethical issues that may not be apparent from a purely scientific perspective.

Ethical leadership in science is about more than just setting rules and guidelines. It involves fostering a culture of ethical responsibility, mentoring future researchers, and leading by example. Leaders in the scientific community play a crucial role in shaping the ethical standards and practices of their fields, influencing how research is conducted and how ethical challenges are addressed.

**Inspiration:** The H5N1 GoF research case inspires a reevaluation of ethical decision-making processes in science, emphasizing the need for an integrated approach that encompasses public engagement, intergovernmental cooperation, and ethical education for researchers. This case serves as a poignant reminder of the global impact of scientific research and the importance of anticipating and mitigating potential risks. It underscores the need for a proactive and collaborative approach to biosecurity, balancing the pursuit of knowledge with the responsibility to protect public health and safety.

The case also highlights the importance of fostering a culture of ethical responsibility within the scientific community. This involves not only adhering to established ethical guidelines and safety protocols but also encouraging open discussion and critical thinking about the broader implications of research. It calls for a shift in the way scientists are trained, emphasizing the importance of ethical considerations alongside technical expertise.

Furthermore, the H5N1 GoF research case illustrates the need for effective communication and public engagement in science.
