import os
os.environ['CURL_CA_BUNDLE'] = ''
model_id = "stabilityai/stable-diffusion-2-base"
import torch
from diffusers import StableDiffusionPipeline, DPMSolverMultistepScheduler
from diffusers import UNet2DModel


# Use the DPMSolverMultistepScheduler (DPM-Solver++) scheduler here instead
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16)
pipe.scheduler = DPMSolverMultistepScheduler.from_config(pipe.scheduler.config)
pipe = pipe.to("cuda")

prompt = ""
image = pipe(prompt).images[0]
image.save("astronaut_rides_horse.png")
