"""Utilities for dealing with numeric quantities."""
import numpy as np
import tensorflow as tf


def about_equal(a, b, eps, *, nameme=1.0):
    # Try to change based on type.
    # TODO: See if that causes issues down the line.
    if isinstance(a, tf.Tensor) or isinstance(b, tf.Tensor):
        abs_ = tf.abs
        max_ = tf.maximum
    elif isinstance(a, np.ndarray) or isinstance(b, np.ndarray):
        abs_ = np.abs
        max_ = np.maximum
    else:
        # Assume a and b are regular Python numbers.
        abs_ = abs
        max_ = max
    return abs_(a - b) < eps * max_(nameme, abs_((a + b) / 2.0))
