"""Configurations for the GLS experiments."""
from scripts.synthetic.gls import Config


CONFIGS = {
    'test': Config(
        name='test',
        m_gen=4,
        m_train=8,
        d=4,
        max_steps=128,
    )
}


def add_cfg(*, m_gen: int, m_train: int, d: int, max_steps: int):
    name = f'mg{m_gen}_mt{m_train}_d{d}_ms{max_steps}'
    cfg = Config(
        name=name,
        m_gen=m_gen,
        m_train=m_train,
        d=d,
        max_steps=max_steps,
    )
    CONFIGS[cfg.name] = cfg


_MAX_STEPS = 1024


_D = [4, 8, 16, 32]
_M_GEN_FACTOR = [0.5, 1, 2]
_M_TRAIN_FACTOR = [1, 3 / 2, 2]

for d in _D:
    for m_gen_factor in _M_GEN_FACTOR:
        m_gen = int(d * m_gen_factor)
        for m_train_factor in _M_TRAIN_FACTOR:
            m_train = m_train_factor * m_gen
            add_cfg(
                m_gen=int(m_gen),
                m_train=int(m_train),
                d=d,
                max_steps=_MAX_STEPS,
            )
