"""Vertex solvers that make use of Python multiprocessing.

Typically, these will use Python multiprocessing to create
several copies of a solver that can run for multiple inputs
in parallel. Generally, these will not make solving a single
instance faster.
"""
import abc
import multiprocessing as mp


KILL_SIGNAL = 'KILL'


class SolverProcessAbc(mp.Process, abc.ABC):

    def __init__(self, request_queue, response_queue, instantiate_solver):
        super().__init__()
        self.request_queue = request_queue
        self.response_queue = response_queue
        self._instantiate_solver = instantiate_solver

    def _initialize(self):
        self.solver = self._instantiate_solver()

    @abc.abstractmethod
    def _process_message(self, msg):
        raise NotImplementedError

    def run(self):
        self._initialize()
        while True:
            msg = self.request_queue.get()
            if msg == KILL_SIGNAL:
                break
            response = self._process_message(msg)
            self.response_queue.put(response)
