import nmmo
import numpy as np
from ijcai2022nmmo.tasks import All

class BaseConfig(nmmo.config.Medium, nmmo.config.AllGameSystems):
    @property
    def SPAWN(self):
        return self.SPAWN_CONCURRENT
    AGENT_LOADER = nmmo.config.TeamLoader
    TASKS = All
    NMAPS = 40
    PATH_MAPS = "maps"

    def SPAWN_CONCURRENT(self, shuffle=True):
        left   = self.TERRAIN_BORDER
        right  = self.TERRAIN_CENTER + self.TERRAIN_BORDER
        rrange = np.arange(left+2, right, 4).tolist()

        assert not self.TERRAIN_CENTER % 4
        per_side = self.TERRAIN_CENTER // 4
        
        lows   = (left+np.zeros(per_side, dtype=np.int)).tolist()
        highs  = (right+np.zeros(per_side, dtype=np.int)).tolist()

        s1     = list(zip(rrange, lows))
        s2     = list(zip(lows, rrange))
        s3     = list(zip(rrange, highs))
        s4     = list(zip(highs, rrange))

        ret = s1 + s2 + s3 + s4
        if shuffle:
            assert not len(ret) % self.NPOP
            ret = np.array_split(ret, self.NPOP)
            np.random.shuffle(ret)
            ret = np.concatenate(ret, axis=0).tolist()
        n = int(self.NENT)
        return ret[:n]

class P4Config(BaseConfig):
    NPOP = 4
    AGENTS = NPOP * [nmmo.Agent]

class P8Config(BaseConfig):
    NPOP = 8
    AGENTS = NPOP * [nmmo.Agent]

class P8A8Config(P8Config):
    NENT = 8 * P8Config.NPOP

class P4A4Config(P4Config):
    NENT = 4 * P4Config.NPOP
    
class P4A8Config(P4Config):
    NENT = 8 * P4Config.NPOP

class P4A16Config(P4Config):
    NENT = 16 * P4Config.NPOP