from typing import Optional

from utils.annotations import override
from utils.schedules.schedule import Schedule
from utils.typing import TensorType


class ConstantSchedule(Schedule):
    """A Schedule where the value remains constant over time."""

    def __init__(self, value: float, framework: Optional[str] = None):
        """Initializes a ConstantSchedule instance.

        Args:
            value: The constant value to return, independently of time.
            framework: The framework descriptor string, e.g. "tf",
                "torch", or None.
        """
        super().__init__(framework=framework)
        self._v = value

    @override(Schedule)
    def _value(self, t: TensorType) -> TensorType:
        return self._v
