from openai import OpenAI
import os
import csv
import time
import re, json

# ==== 你需要填的配置 ====
client = OpenAI(api_key = "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")   # ← 替换为你的 key

# INPUT_FILE = "tem"    # 每行一条攻略（或者你可以改成自己的数据读取方式）
OUTPUT_FILE = "scored_travel_4o.json"   # 输出打分结果

# ==== 评分维度，你可以改/扩展 ====
CRITERIA = [
    "准确性（内容真实/地点正确/无虚假）",
    "实用性（建议可落地，对旅行有实际帮助）",
    "完整性（涵盖吃住行玩，推荐丰富）",
    "可读性（条理清晰，表达流畅）"
]



def gpt4_judge(guide_text, departure_city, destination_city, departure_date, budget, traveler_count, days):
    prompt = f"""你是一名资深旅行编辑。请从根据用户的需求从以下维度对这篇旅行攻略进行1-20分打分，并简要评价：
1. 准确性（内容真实/地点正确/无虚假/无错误）
2. 实用性（建议可落地，对旅行有实际帮助）
3. 完整性（涵盖吃住行玩，推荐丰富）
4. 可读性（条理清晰，表达流畅）
5. 忠实性 (各部分开销之和是否符合总预算要求)

请返回如下JSON格式：
{{
  "准确性": X,
  "实用性": X,
  "完整性": X,
  "可读性": X,
  "忠实性": X,
  "总分": X,
  "点评": "你的简评"
}}

用户需求如下：
出发城市: {departure_city}
目的地城市: {destination_city}
出发日期: {departure_date}
预算: {budget}
旅行人数: {traveler_count}
旅行天数: {days}

待评分文本如下：
-----------------
{guide_text}
-----------------
"""
    response = client.chat.completions.create(
        model="gpt-4o",  # 推荐 gpt-4o 或 gpt-4
        messages=[
            {"role": "user", "content": prompt}
        ],
        temperature=0
    )
    # 把返回内容转为字典
    return response.choices[0].message.content

import os
def get_log_files():
    """获取output/KnowGraph目录下的所有json日志文件"""
    # 日志文件目录
    log_dir = "output/travel"
    
    # 获取目录下所有json文件
    log_files = []
    for file in os.listdir(log_dir):
        if file.endswith('.json'):
            log_files.append(os.path.join(log_dir, file))
            
    return log_files

import json
from tqdm import tqdm
def main():
    log_files = get_log_files()
    results = []
    for log_file in tqdm(log_files):
        
        with open(log_file, encoding="utf-8") as f:
            log_data = json.load(f)
            guide = log_data['answer']
            departure_city = log_data['departure_city']
            destination_city = log_data['destination_city']
            departure_date = log_data['departure_date']
            days = log_data['days']
            budget = log_data['budget']
            traveler_count = log_data['traveler_count']
            #return_date = log_data['return_date']

            scores = gpt4_judge(guide, departure_city, destination_city, departure_date, budget, traveler_count, days)

        # 保存到CSV
        results.append({
            "id": log_data['id'],
            "filename": log_file,
            "guide": guide,
            "score": scores
        })

    # 保存到JSON
    with open(OUTPUT_FILE, "w", encoding="utf-8") as f:
        json.dump(results, f, ensure_ascii=False, indent=4)

    print(f"全部打分完成，结果已保存到 {OUTPUT_FILE}")

def select_low_score_guides():
    """选择分数较低的旅行指南"""
    # 读取scored_guides_4o.json文件
    with open("scored_travel_4o.json", "r", encoding="utf-8") as f:
        scored_guides = json.load(f)
    low_score_guides = []
    for scored_guide in scored_guides:
        id = scored_guide['id']
        guide = scored_guide['guide']
        score = scored_guide['score']
        raw_score = re.sub(r'```json|```', '', score).strip()
        try:
            data = json.loads(raw_score)
            if data['总分'] < 55:
                # 将分数低的指南保存到guide_low.json  
                low_score_guides.append({
                    "guide": guide,
                    "score": data['总分'],
                    "评分详情": data
                })
        except:
            print(f"解析失败: {id}")
    print(len(low_score_guides))
    # 写入json文件
    with open("travel_low.json", "w", encoding="utf-8") as f:
        json.dump(low_score_guides, f, ensure_ascii=False, indent=4)

        
    


if __name__ == "__main__":
    #main()
    select_low_score_guides()
