package java_programs;
import java.util.*;
import java.lang.*;

public class KNAPSACK {
    public static int knapsack(int capacity, int [][] items) {
        int n = items.length;
        int memo[][] = new int[n + 1][capacity + 1];

        for (int i = 0; i <= n; i++) {
            for (int j = 0; j <= capacity; j++) {
                if (i == 0 || j == 0) {
                    memo[i][j] = 0;
                } else if (items[i-1][0] <= j) {  // current item can fit
                    int currentWeight = items[i-1][0];
                    int currentValue = items[i-1][1];
                    memo[i][j] = Math.max(memo[i-1][j], currentValue + memo[i-1][j-currentWeight]);
                } else {
                    memo[i][j] = memo[i-1][j];
                }
            }
        }
        return memo[n][capacity];
    }
}