package java_programs;
import java.util.*;

public class LEVENSHTEIN {
    public static int levenshtein(String source, String target) {
        if (source.isEmpty()) {
            return target.length();
        }
        if (target.isEmpty()) {
            return source.length();
        }

        int cost;
        if (source.charAt(0) == target.charAt(0)) {
            cost = 0;
        } else {
            cost = 1;
        }

        int delete = levenshtein(source.substring(1), target) + 1;
        int insert = levenshtein(source, target.substring(1)) + 1;
        int replace = levenshtein(source.substring(1), target.substring(1)) + cost;

        return Math.min(Math.min(delete, insert), replace);
    }
}