package java_programs;
import java.util.*;

public class LIS {
    public static int lis(int[] arr) {
        if (arr == null || arr.length == 0) {
            return 0;
        }
        
        Map<Integer, Integer> ends = new HashMap<>();
        int longest = 0;

        for (int i = 0; i < arr.length; i++) {
            int val = arr[i];
            int low = 1, high = longest;
            
            while (low <= high) {
                int mid = (low + high) / 2;
                if (arr[ends.get(mid)] < val) {
                    low = mid + 1;
                } else {
                    high = mid - 1;
                }
            }

            ends.put(low, i);
            
            if (low > longest) {
                longest = low;
            }
        }
        
        return longest;
    }
}