package java_programs;
import java.util.*;

public class Node {

    private String value;
    private Node successor; // Single successor
    private ArrayList<Node> successors; // List of successors
    private ArrayList<Node> predecessors; // List of predecessors

    // Constructor overloading for different use cases
    public Node() {
        this.value = null;
        this.successor = null;
        this.successors = new ArrayList<>();
        this.predecessors = new ArrayList<>();
    }

    public Node(String value) {
        this.value = value;
        this.successor = null;
        this.successors = new ArrayList<>();
        this.predecessors = new ArrayList<>();
    }

    public Node(String value, Node successor) {
        this.value = value;
        this.successor = successor;
        this.successors = new ArrayList<>(); // Initialize empty list for consistency
        this.predecessors = new ArrayList<>(); // Initialize empty list for consistency
    }

    public Node(String value, ArrayList<Node> successors) {
        this.value = value;
        this.successors = new ArrayList<>(successors);
        this.predecessors = new ArrayList<>(); // Initialize empty list for consistency
        this.successor = (successors != null && !successors.isEmpty()) ? successors.get(0) : null;
    }

    public Node(String value, ArrayList<Node> predecessors, ArrayList<Node> successors) {
        this.value = value;
        this.predecessors = new ArrayList<>(predecessors);
        this.successors = new ArrayList<>(successors);
        this.successor = (successors != null && !successors.isEmpty()) ? successors.get(0) : null;
    }

    // Getters and setters for accessing and updating the fields
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Node getSuccessor() {
        return successor;
    }

    public void setSuccessor(Node successor) {
        this.successor = successor;
    }

    public ArrayList<Node> getSuccessors() {
        return new ArrayList<>(successors);
    }

    public void setSuccessors(ArrayList<Node> successors) {
        this.successors = new ArrayList<>(successors);
        this.successor = (successors != null && !successors.isEmpty()) ? successors.get(0) : null;
    }

    public ArrayList<Node> getPredecessors() {
        return new ArrayList<>(predecessors);
    }

    public void setPredecessors(ArrayList<Node> predecessors) {
        this.predecessors = new ArrayList<>(predecessors);
    }
}