from collections import deque as Queue

def breadth_first_search(startnode, goalnode):
    queue = Queue()
    queue.append(startnode)

    visited_nodes = set()
    visited_nodes.add(startnode)

    while queue:
        current_node = queue.popleft()

        if current_node == goalnode:
            return True

        for successor in current_node.successors:
            if successor not in visited_nodes:
                queue.append(successor)
                visited_nodes.add(successor)

    return False