def max_sublist_sum(arr):
    if not arr:
        return 0
    
    max_ending_here = arr[0]
    max_so_far = arr[0]

    for x in arr[1:]:
        max_ending_here = max(max_ending_here + x, x)
        max_so_far = max(max_so_far, max_ending_here)

    return max_so_far

# Test cases
def test_max_sublist_sum():
    # Test case with positive numbers
    result1 = max_sublist_sum([1, 2, 3, 4])
    assert result1 == 10, f"Expected 10, got {result1}"

    # Test case with negative numbers
    result2 = max_sublist_sum([-1, -2, -3, -4])
    assert result2 == -1, f"Expected -1, got {result2}"

    # Test case with a mix with positive larger sum
    result3 = max_sublist_sum([4, -1, 2, 1])
    assert result3 == 6, f"Expected 6, got {result3}"

    # Test case with a mix with negatives dominating
    result4 = max_sublist_sum([-1, 2, 3, -7, 5, -3, 6])
    assert result4 == 8, f"Expected 8, got {result4}"  # Subarray: [5, -3, 6]

    # Test case with single element
    result5 = max_sublist_sum([5])
    assert result5 == 5, f"Expected 5, got {result5}"

    # Test case with an empty list
    result6 = max_sublist_sum([])
    assert result6 == 0, f"Expected 0, got {result6}"

test_max_sublist_sum()