def shunting_yard(tokens):
    precedence = {
        '+': 1,
        '-': 1,
        '*': 2,
        '/': 2
    }

    associate = {
        '+': 'L',
        '-': 'L',
        '*': 'L',
        '/': 'L',
    }

    rpntokens = []
    opstack = []
    for token in tokens:
        if isinstance(token, int):
            rpntokens.append(token)
        else:
            while (opstack and precedence[opstack[-1]] > precedence[token]) or \
                  (opstack and precedence[opstack[-1]] == precedence[token] and associate[token] == 'L'):
                rpntokens.append(opstack.pop())
            opstack.append(token)

    while opstack:
        rpntokens.append(opstack.pop())

    return rpntokens