def subsequences(a, b, k):
    if k == 0 or a > b:
        return [[]] if k == 0 else []

    ret = []
    for i in range(a, b + 1 - k + 1):
        for rest in subsequences(i + 1, b, k - 1):
            ret.append([i] + rest)

    return ret

# Test cases
print(subsequences(1, 5, 3))  # Expected: [[1, 2, 3], [1, 2, 4], [1, 2, 5], [1, 3, 4], [1, 3, 5], [1, 4, 5], [2, 3, 4], [2, 3, 5], [2, 4, 5], [3, 4, 5]]
print(subsequences(1, 2, 3))  # Expected: []
print(subsequences(1, 4, 2))  # Expected: [[1, 2], [1, 3], [1, 4], [2, 3], [2, 4], [3, 4]]