package java_programs;

/**
 * Class to reverse a linked list.
 */
public class ReverseLinkedList {

    /**
     * Reverses the nodes in a linked list.
     *
     * @param node The head of the linked list to be reversed.
     * @return The new head of the reversed linked list.
     */
    public static Node reverseLinkedList(Node node) {
        Node previousNode = null;
        Node nextNode;
        while (node != null) {
            nextNode = node.getSuccessor();
            node.setSuccessor(previousNode);
            previousNode = node;
            node = nextNode;
        }
        return previousNode;
    }

    /**
     * Definition for singly-linked list.
     */
    static class Node {
        private int data;
        private Node next;

        public Node(int data) {
            this.data = data;
            this.next = null;
        }

        public Node(int data, Node next) {
            this.data = data;
            this.next = next;
        }

        public Node getSuccessor() {
            return this.next;
        }

        public void setSuccessor(Node successor) {
            this.next = successor;
        }
    }
}

//模型忽略 Prompt，回答跑题或冗余