package java_programs;
import java.util.*;

public class MAX_SUBLIST_SUM {
    public static int max_sublist_sum(int[] arr) {
        if (arr == null || arr.length == 0) return 0;

        int max_ending_here = 0;
        int max_so_far = Integer.MIN_VALUE;
        boolean allNegative = true;
        int largestNegative = Integer.MIN_VALUE;

        for (int x : arr) {
            if (x > 0) {
                allNegative = false;
            }
            if (x > largestNegative) {
                largestNegative = x;
            }
            
            max_ending_here = max_ending_here + x;
            if (max_ending_here > max_so_far) {
                max_so_far = max_ending_here;
            }
            if (max_ending_here < 0) {
                max_ending_here = 0;
            }
        }

        return allNegative ? largestNegative : max_so_far;
    }
}