package java_programs;

import java.util.*;

public class POWERSET {
    public static ArrayList<ArrayList<Object>> powerset(ArrayList<Object> arr) {
        ArrayList<ArrayList<Object>> subsets = new ArrayList<>();
        if (arr.isEmpty()) {
            subsets.add(new ArrayList<>());
            return subsets;
        } else {
            // split the input into a head and rest
            Object head = arr.get(0);
            ArrayList<Object> rest = new ArrayList<>(arr.subList(1, arr.size()));

            // recursive call
            for (ArrayList<Object> subset : powerset(rest)) {
                ArrayList<Object> newSubset = new ArrayList<>(subset);
                subsets.add(newSubset);
                newSubset = new ArrayList<>(subset);
                newSubset.add(0, head);
                subsets.add(newSubset);
            }
            return subsets;
        }
    }
}