package java_programs;
import java.util.*;

/**
 * A class that generates all k-length subsequences of integers in the range [a, b).
 */
public class SUBSEQUENCES {
    public static ArrayList<ArrayList<Integer>> subsequences(int a, int b, int k) {
        // Base case: if k is 0, return a list containing an empty list
        if (k == 0) {
            ArrayList<ArrayList<Integer>> result = new ArrayList<>();
            result.add(new ArrayList<>());
            return result;
        }

        ArrayList<ArrayList<Integer>> ret = new ArrayList<>();
        for (int i = a; i <= b - k; i++) {
            // Generate subsequences of length k-1 starting from the next integer
            for (ArrayList<Integer> rest : subsequences(i + 1, b, k - 1)) {
                // Add the current integer to the beginning of each subsequence
                rest.add(0, i);
                ret.add(rest);
            }
        }

        return ret;
    }
}