def kheapsort(arr, k):
    import heapq

    # Create a heap from the first k+1 elements
    heap = arr[:k + 1]
    heapq.heapify(heap)

    # Process the initial heap and the next elements in the list
    for i in range(k + 1, len(arr)):
        # Push new element, pop the smallest element
        yield heapq.heappushpop(heap, arr[i])

    # Empty the heap of the initial elements without any new elements being added
    while heap:
        yield heapq.heappop(heap)