from .node import Node
from .reverse_linked_list import reverse_linked_list

"""
Driver to test reverse linked list
"""
def main():
    # Case 1: 5-node list input
    # Expected Output: 1 2 3 4 5
    node1 = Node(1)
    node2 = Node(2, next_node=node1)
    node3 = Node(3, next_node=node2)
    node4 = Node(4, next_node=node3)
    node5 = Node(5, next_node=node4)

    result = reverse_linked_list(node5)

    if result is node1:
        print("Reversed!", end=" ")
    else:
        print("Not Reversed!", end=" ")
    
    while result is not None:
        print(result.value, end=" ")
        result = result.successor
    print()

    # Case 2: 1-node list input
    # Expected Output: 0
    node = Node(0)
    result = reverse_linked_list(node)

    if result is node:
        print("Reversed!", end=" ")
    else:
        print("Not Reversed!", end=" ")

    while result is not None:
        print(result.value, end=" ")
        result = result.successor
    print()

    # Case 3: None input
    # Expected Output: None
    result = reverse_linked_list(None)
    
    if result is None:
        print("Reversed!", end=" ")
    else:
        print("Not Reversed!", end=" ")

if __name__ == "__main__":
    main()