from node import Node
from shortest_path_length import shortest_path_length

"""
Test shortest path length
"""
def main():
    node1 = Node("1")
    node5 = Node("5")
    node4 = Node("4", neighbors=[node5])
    node3 = Node("3", neighbors=[node4])
    node2 = Node("2", neighbors=[node1, node3, node4])
    node0 = Node("0", neighbors=[node2, node5])

    length_by_edge = {
        (node0, node2): 3,
        (node0, node5): 10,
        (node2, node1): 1,
        (node2, node3): 2,
        (node2, node4): 4,
        (node3, node4): 1,
        (node4, node5): 1
    }

    # Case 1: One path
    result = shortest_path_length(length_by_edge, node0, node1)
    print(result)  # Output: 4

    # Case 2: Multiple path
    result = shortest_path_length(length_by_edge, node0, node5)
    print(result)  # Output: 7

    # Case 3: Start point is same as end point
    result = shortest_path_length(length_by_edge, node2, node2)
    print(result)  # Output: 0

    # Case 4: Unreachable path
    result = shortest_path_length(length_by_edge, node1, node5)
    print(result)  # Output: should be a large number indicating unreachability, typically sys.maxsize or float('inf')

if __name__ == "__main__":
    main()