from collections import defaultdict

def shortest_path_lengths(n, length_by_edge):
    # Initialize a dictionary to store the shortest path lengths between all pairs
    length_by_path = defaultdict(lambda: float('inf'))
    
    # Set the distance from each node to itself as 0
    for i in range(n):
        length_by_path[i, i] = 0

    # Update the dictionary with the given edges' lengths
    length_by_path.update(length_by_edge)

    # Use Floyd-Warshall algorithm to find the shortest path between all pairs of nodes
    for k in range(n):
        for i in range(n):
            for j in range(n):
                if length_by_path[i, k] + length_by_path[k, j] < length_by_path[i, j]:
                    length_by_path[i, j] = length_by_path[i, k] + length_by_path[k, j]

    # Convert defaultdict to regular dict for the final output
    return dict(length_by_path)