import requests

API_KEY = 'app-ukJxhYup8BXA52vmcdbn2gjB'
API_URL = 'http://localhost/v1/chat-messages'  # 云端请替换为实际地址
USER_ID = "abc-123"
# CONVERSATION_ID = "4df9b765-56dd-4af8-a3f3-5fa7751d7ce1"
# LIMIT = 20
# CHAT_URL = f"http://localhost/v1/messages?user={USER_ID}&conversation_id={CONVERSATION_ID}&limit={LIMIT}"

# # from googletrans import Translator
# from deep_translator import GoogleTranslator

# # translator = Translator()
import pandas as pd
import os
import json, re

from openai import OpenAI
import PyPDF2
import requests
from io import BytesIO

# 设置你的OpenAI API Key
client = OpenAI(api_key = "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")


def judge_similarity(text1, text2):
    """
    判断两个文本的相似度
    """
    prompt = f"""你是一个语义识别专家，请判断下面两个文本是否描述的是否为同一件事情或同一对象，即便它们使用了不同的语言、表达方式或名称。如果文本中包含非英语的内容，则你可以将它们转成英语后再比较。
    我会给你两个文本{text1}和{text2}，请判断它们是否在描述同一个事物，如果是，则输出True，反之则输出False。
    请注意，当两个文本是描述同一个事物时，它们可能会有不同的表述方式，包括但不限于不同的说法、中文与英文等等，例如：The US 和 America，特朗普和Trump，6.213 km long和 6.213 kilometers，在这时，你应该输出True。当两个文本是数值时，例如：100和100.0，在这时，你应该输出True，两个数值不相等时，你应该输出False。
    在判断结束后，你只需输出True或False。
    """
    response = client.chat.completions.create(
        model="gpt-3.5-turbo",
        messages=[
            {"role": "system", "content": "你是一名专业的语义识别专家。"},
            {"role": "user", "content": prompt}
        ],
        temperature=0.2
    )  
    return response.choices[0].message.content


def get_math_dataset():
    """
    读取parquet文件并返回包含question和final_answer的字典数组
    
    Returns:
        list: 包含字典的列表，每个字典包含'question'和'answer'字段
    """
    try:
        # 文件路径
        file_path = 'templates/dataset/train-00000-of-00001.parquet'
        
        # 检查文件是否存在
        if not os.path.exists(file_path):
            print(f"文件 {file_path} 不存在")
            return []
        
        # 读取parquet文件
        df = pd.read_parquet(file_path)
        
        # 提取所需数据并转换为字典数组
        math_dataset = []
        for _, row in df.iterrows():
            # 分离出最终答案（###后面的数字）
            final_answer = row['answer'].split('####')[-1].strip()
            
            # 添加到结果列表
            math_dataset.append({
                'question': row['question'],
                'answer': final_answer
            })
            
        return math_dataset
        
    except Exception as e:
        print(f"读取文件时出错: {str(e)}")
        return []

def get_Q_A_dataset():
    """
    读取hotpot_train_v1.1.json文件并返回问答数据集
    
    Returns:
        list: 包含字典的列表，每个字典包含'question'和'answer'字段
    """
    try:
        # 文件路径
        file_path = 'templates/dataset/hotpot_train_v1.1.json'
        
        # 检查文件是否存在
        if not os.path.exists(file_path):
            print(f"文件 {file_path} 不存在")
            return []
            
        # 读取json文件
        with open(file_path, 'r', encoding='utf-8') as f:
            data = json.load(f)
        # # 打印第一条数据
        # if len(data) > 0:
        #     print("第一条数据:")
        #     print(json.dumps(data[0], ensure_ascii=False, indent=2))
        # 提取问题和答案
        qa_dataset = []
        for item in data:
            qa_dataset.append({
                'question': item['question'],
                'answer': item['answer']
            })
        
        return qa_dataset
        
    except Exception as e:
        print(f"读取文件时出错: {str(e)}")
        return []

from datasets import load_dataset

def get_humaneval_dataset():
    human_eval_dataset = []

    # 加载 HumanEval 的 test split（这是唯一的官方划分）
    dataset = load_dataset("openai_humaneval", split="test")

    # 输出前 3 条样本内容
    for i in range(len(dataset)):
        item = dataset[i]
        # print(f"\n样本 {i + 1}")
        # print("任务 ID:", item["task_id"])
        # print("代码提示 (prompt):\n", item["prompt"])
        # print("参考答案 (solution):\n", item["canonical_solution"])
        # print("测试代码 (test):\n", item["test"])
        human_eval_dataset.append({
            'question': item["prompt"],
            'answer': item["canonical_solution"]
        })
    return human_eval_dataset

def get_humaneval_plus_dataset():
    human_eval_plus_dataset = []
    dataset = load_dataset("evalplus/humanevalplus", split="test")
    for i in range(len(dataset)):
        item = dataset[i]
        human_eval_plus_dataset.append({
            'question': item["prompt"],
            'answer': item["canonical_solution"]
        })
    return human_eval_plus_dataset

def get_apps_dataset():
    apps_dataset = []

    root_path = 'templates/dataset/APPS/train'
    # 获取data_dir下的所有文件夹列表

    subdirs = sorted([
        name for name in os.listdir(root_path)
        if os.path.isdir(os.path.join(root_path, name))
    ])
    
    for subdir in subdirs:
        problem_path = os.path.join(root_path, subdir, 'question.txt')
        # print(problem_path)
        with open(problem_path, 'r', encoding='utf-8') as f:
            question = f.read()
        apps_dataset.append({
            'id': subdir,
            'question': question
        })
    return apps_dataset


def get_swe_dataset():
    """
    读取parquet文件并返回包含question和final_answer的字典数组
    
    Returns:
        list: 包含字典的列表，每个字典包含'question'和'answer'字段
    """
    try:
        # 文件路径
        file_path = 'templates/dataset/swe-bench-lite/test-00000-of-00001.parquet'
        
        # 检查文件是否存在
        if not os.path.exists(file_path):
            print(f"文件 {file_path} 不存在")
            return []
        
        # 读取parquet文件
        df = pd.read_parquet(file_path)
        
        # 提取所需数据并转换为字典数组
        swe_dataset = []
        for _, row in df.iterrows():
            instance_id = row['instance_id']
            question = row['problem_statement']
            repo = row['repo']
            hints = row['hints_text']
            swe_dataset.append({
                'id': instance_id,
                'repo': repo,
                'question': question,
                'hints': hints
            })
            
        return swe_dataset
        
    except Exception as e:
        print(f"读取文件时出错: {str(e)}")
        return []
# print(get_swe_dataset())

def get_QuixBugs_dataset():
    QuixBugs_dataset = []
    file_path = 'templates/dataset/QuixBugs/python_programs'
        
    # 只读取.py文件
    QuixBugs_dataset = []
    for file in os.listdir(file_path):
        if file.endswith('.py'):
            with open(os.path.join(file_path, file), 'r', encoding='utf-8') as f:
                question = f.read()
            QuixBugs_dataset.append({
                'name': file,
                'question': question
            })
    return QuixBugs_dataset
    
def get_QuixBugs_java_dataset():
    QuixBugs_dataset = []
    file_path = 'templates/dataset/QuixBugs/java_programs'
        
    # 只读取.py文件
    QuixBugs_dataset = []
    for file in os.listdir(file_path):
        if file.endswith('.java'):
            with open(os.path.join(file_path, file), 'r', encoding='utf-8') as f:
                question = f.read()
            QuixBugs_dataset.append({
                'name': file,
                'question': question
            })
    return QuixBugs_dataset

# get_QuixBugs_dataset()       

headers = {
    'Authorization': f'Bearer {API_KEY}',
    'Content-Type': 'application/json'
}

# 获取math数据集
#dataset_math = get_math_dataset()
# 获取问答数据集
# dataset_qa = get_Q_A_dataset()
# print(dataset_qa)
# 获取humaneval数据集
# dataset_humaneval = get_humaneval_dataset()
# print(dataset_humaneval)

#dataset_apps = get_apps_dataset()
# print(dataset_apps)

# 运行math数据集
def run_math_dataset(dataset_math):
    for i, item in enumerate(dataset_math[:100]):
        print(f"\n样本 {i+1}:")
        print(f"问题: {item['question']}")
        print(f"答案: {item['answer']}")
        print("-" * 50)

        # 你要发送的消息内容
        query = item['question'] + 'At the end of discussion, please output the final result in the format of "The final result is: ***result*** " with only number.'

        # 如果你的应用有自定义 inputs，可以在这里填写
        inputs = {
            # "input1": "value1",
            # "input2": "value2",
        }

        # 如果需要上传文件（如图片），可以这样写
        # files = [
        #     {
        #         "type": "image",
        #         "transfer_method": "remote_url",
        #         "url": "https://cloud.dify.ai/logo/logo-site.png"
        #     }
        # ]

        payload = {
            "inputs": inputs,
            "query": query,
            "response_mode": "blocking",  # 或 "streaming"
            "user": "abc-123",            # 可选，用户ID
            "conversation_id": ""        # 可选，首次对话留空，后续对话填前一次返回的 conversation_id
            # "files": files                # 可选，文件输入
        }

        response = requests.post(API_URL, headers=headers, json=payload)

        if response.status_code == 200:
            print("运行成功，原始返回内容如下：")
            print(response.text)  # 先打印原始内容
            
            data = json.loads(response.text)
            answer = data.get("answer")
            print('answer:', answer)
            # 提取数字部分
            match = re.search(r"The final result is: (\d+)", answer)
            if match:
                final_result = int(match.group(1))
                print("最终结果为:", final_result)
            else:
                print("未找到结果")
            result = float(final_result)  # 转换为数字
            # print(result)
            # 对比结果
            if abs(result - float(item['answer'])) > 1e-6:  # 使用浮点数比较
                # 创建output/Cot目录(如果不存在)
                os.makedirs('output/Cot/Math', exist_ok=True)
                
                # 生成日志文件名
                import datetime
                timestamp = datetime.datetime.now().strftime('%Y%m%d_%H%M%S')
                log_filename = f'output/Cot/cot_log_{timestamp}.txt'
                
                # 写入日志文件
                with open(log_filename, 'w', encoding='utf-8') as f:
                    f.write(f"问题: {item['question']}\n")
                    f.write(f"期望答案: {item['answer']}\n") 
                    f.write(f"实际结果: {result}\n")
                    f.write("\n完整响应:\n")
                    f.write(response.text)
            try:
                print(response.json())
            except Exception as e:
                print("返回内容不是合法的JSON，错误信息：", e)
        else:
            print("运行失败，状态码：", response.status_code)
            print(response.text)

def run_qa_dataset(dataset_qa):
    for i, item in enumerate(dataset_qa[:100]):
        print(f"\n样本 {i+1}:")
        print(f"问题: {item['question']}")
        print(f"答案: {item['answer']}")
        print("-" * 50)
        # 你要发送的消息内容
        query = item['question'] + ' At the end of discussion, please output the final result directly, without any other text.'

        # 如果你的应用有自定义 inputs，可以在这里填写
        inputs = {
            # "input1": "value1",
            # "input2": "value2",
        }

        # 如果需要上传文件（如图片），可以这样写
        # files = [
        #     {
        #         "type": "image",  
        #         "transfer_method": "remote_url",
        #         "url": "https://cloud.dify.ai/logo/logo-site.png"
        #     }
        # ]

        payload = {
            "inputs": inputs,
            "query": query,
            "response_mode": "blocking",  # 或 "streaming"
            "user": "abc-123",            # 可选，用户ID
            "conversation_id": ""        # 可选，首次对话留空，后续对话填前一次返回的 conversation_id
            # "files": files                # 可选，文件输入
        }

        response = requests.post(API_URL, headers=headers, json=payload)

        if response.status_code == 200:
            print("运行成功，原始返回内容如下：")
            print(response.text)  # 先打印原始内容
            
            data = json.loads(response.text)
            answer = data.get("answer")
            print('answer:', answer)

            # 使用正则表达式提取“## 最终结论”后的文本内容
            match = re.search(r"## 最终结论\s*(.+)", answer)

            if match:
                final_conclusion = match.group(1).strip()
                print("最终结论内容:", final_conclusion)
            else:
                print("未找到最终结论内容")
            
            is_same = judge_similarity(final_conclusion, item['answer'])
            if final_conclusion.lower() != item['answer'].lower() and is_same != 'True':
                print("最终结论与期望答案不一致")
                # 创建output/Cot目录(如果不存在)
                os.makedirs('output/Cot/QA2', exist_ok=True)
                # 生成日志文件名
                import datetime
                timestamp = datetime.datetime.now().strftime('%Y%m%d_%H%M%S')
                log_filename = f'output/Cot/QA2/cot_log_{timestamp}.txt'
                
                # 写入日志文件
                with open(log_filename, 'w', encoding='utf-8') as f:
                    f.write(f"问题: {item['question']}\n")
                    f.write(f"最终结论: {is_same}\n")
                    f.write(f"期望答案: {item['answer']}\n") 
                    f.write(f"实际结果: {answer}\n")
                    f.write("\n完整响应:\n")    
                    f.write(response.text)
            try:
                print(response.json())
            except Exception as e:
                print("返回内容不是合法的JSON，错误信息：", e)
        else:
            print("运行失败，状态码：", response.status_code)
# response = requests.get(CHAT_URL, headers=headers)
# if response.status_code == 200:
#     data = response.json()
#     for msg in data["data"]:
#         print("消息ID:", msg["id"])
#         print("输入(query):", msg.get("query"))
#         print("输出(answer):", msg.get("answer"))
#         print("="*30)
# else:
#     print("请求失败:", response.status_code, response.text)


def run_humaneval_dataset(dataset_humaneval):
    for i, item in enumerate(dataset_humaneval[100:]):
        print(f"\n样本 {i+101}:")
        print(f"问题: {item['question']}")
        print(f"答案: {item['answer']}")
        print("-" * 50)
        
        # 你要发送的消息内容
        query = 'Please write a python code according to the following description:\n' + item['question'] +'\n Please note that you just need to output the python code, without any other text.'

        # 如果你的应用有自定义 inputs，可以在这里填写
        inputs = {
            # "input1": "value1",
            # "input2": "value2",
        }

        payload = {
            "inputs": inputs,
            "query": query,
            "response_mode": "blocking",  # 或 "streaming"
            "user": "abc-123",            # 可选，用户ID
            "conversation_id": ""        # 可选，首次对话留空，后续对话填前一次返回的 conversation_id
        }

        response = requests.post(API_URL, headers=headers, json=payload)

        if response.status_code == 200:
            print("运行成功，原始返回内容如下：")
            print(response.text)  # 先打印原始内容
            
            data = json.loads(response.text)
            answer = data.get("answer")
            #print('answer:', answer)

            # 确保输出目录存在
            output_dir = 'output/Cot/HumanEval2'
            if not os.path.exists(output_dir):
                os.makedirs(output_dir)
                
            # 生成输出文件名
            output_file = os.path.join(output_dir, f'humaneval_log_{i+100}.txt')
            
            # 将结果写入文件
            with open(output_file, 'a', encoding='utf-8') as f:
                f.write(answer)




def run_apps_dataset(dataset_apps):
    for i, item in enumerate(dataset_apps[:500]):
        print(f"\n样本 {i+1}:")
        # print(f"问题: {item['question']}")
        # print("-" * 50)
        
        query = 'Please write a python code according to the following description:\n' + item['question'] +'\n Please note that you just need to output the python code, without any other text.'

        inputs = {
            # "input1": "value1",
            # "input2": "value2",
        }

        payload = {
            "inputs": inputs,
            "query": query,
            "response_mode": "blocking",  # 或 "streaming"
            "user": "abc-123",            # 可选，用户ID
            "conversation_id": ""        # 可选，首次对话留空，后续对话填前一次返回的 conversation_id
        }

        response = requests.post(API_URL, headers=headers, json=payload)
        print(response.status_code)

        if response.status_code == 200:
            print("运行成功，原始返回内容如下：")
            # print(response.text)  # 先打印原始内容
            
            data = json.loads(response.text)
            answer = data.get("answer")
            #print('answer:', answer)

            # 确保输出目录存在
            output_dir = 'output/Cot/APPS'
            if not os.path.exists(output_dir):
                os.makedirs(output_dir)
                
            # 生成输出文件名
            output_file = os.path.join(output_dir, f'apps_log_{i}.txt')
            
            # 将结果写入文件
            with open(output_file, 'a', encoding='utf-8') as f:
                f.write(answer)
            print("运行成功，结果已写入文件：", output_file)
            

from tqdm import tqdm
def run_mbpp_dataset():
    dataset = load_dataset("mbpp", split="test")
    count = 0
    for i, item in tqdm(enumerate(dataset)):
        # if count > 100:
        #     break
        # count += 1
        print(f"\n样本 {i+1}:")
        print(f"问题: {item['text']}")
        print(f"答案: {item['code']}")
        print(f"测试用例: {item['test_list']}")
        print("-" * 50)

        # 你要发送的消息内容
        query = 'Please write a python code according to the following description:\n' + item['text'] +'\n. The test cases are as follows:\n' + str(item['test_list']) + '\n.' + 'Please note that the function name you generate should be the same as the function name in the test cases, and you just need to output the python code, without any other text.'

        # 如果你的应用有自定义 inputs，可以在这里填写
        inputs = {
            # "input1": "value1",
            # "input2": "value2",
        }

        payload = {
            "inputs": inputs,
            "query": query,
            "response_mode": "blocking",  # 或 "streaming"
            "user": "abc-123",            # 可选，用户ID
            "conversation_id": ""        # 可选，首次对话留空，后续对话填前一次返回的 conversation_id
        }

        response = requests.post(API_URL, headers=headers, json=payload)

        if response.status_code == 200:
            print("运行成功，原始返回内容如下：")
            print(response.text)  # 先打印原始内容
            
            data = json.loads(response.text)
            answer = data.get("answer")
            #print('answer:', answer)

            # 确保输出目录存在
            output_dir = 'output/Cot/MBPP'
            if not os.path.exists(output_dir):
                os.makedirs(output_dir)
                
            # 生成输出文件名
            output_file = os.path.join(output_dir, f'mbpp_log_{i}.txt')
            
            # 将结果写入文件
            with open(output_file, 'a', encoding='utf-8') as f:
                f.write(answer)
        

def run_swe_dataset():
    dataset = get_swe_dataset()
    for i in range(150):
        item = dataset[i]
        print(f"\n样本 {i+1}:")
        print(f"id: {item['id']}")
        # print(f"问题: {item['question']}")
        # print(f"repo: {item['repo']}")
        print("-" * 50)

        query = "You are a code fixer for generating patch. Given the following problem statement and a GitHub repository link, generate a unified diff patch that fixes the described problem. The patch should be in diff format, suitable for applying with git apply.\n\n Problem Statement:\n"+item['question'] + '\n\nGithub repository link:\nhttps://github.com/'+item['repo'] + '\n\n. The hints are as follows (if there are some hints):\n'+item['hints'] + '\nDo not include any explanations, comments, or extra text—output only the patch.'

        inputs = {
            # "input1": "value1",
            # "input2": "value2",
        }

        payload = {
            "inputs": inputs,
            "query": query,
            "response_mode": "blocking",  # 或 "streaming"            
            "user": "abc-123",            # 可选，用户ID
            "conversation_id": ""        # 可选，首次对话留空，后续对话填前一次返回的 conversation_id
        }

        response = requests.post(API_URL, headers=headers, json=payload)
        # print(response.text)

        if response.status_code == 200:
            print("运行成功，原始返回内容如下：")
            print(response.text)  # 先打印原始内容  
            
            data = json.loads(response.text)
            answer = data.get("answer")
            print('answer:', answer)  

            # 确保输出目录存在
            output_dir = 'output/Cot/SWE3'
            if not os.path.exists(output_dir):
                os.makedirs(output_dir)
            
            # 将结果写入json文件
            result = {
                "id": item['id'],
                "question": item['question'], 
                "answer": answer
            }
            
            # 修改文件扩展名为.json
            output_file = os.path.join(output_dir, f'swe_log_{i}.json')
            
            with open(output_file, 'w', encoding='utf-8') as f:
                json.dump(result, f, ensure_ascii=False, indent=2)
            print("运行成功，结果已写入JSON文件：", output_file)



def run_QuixBugs_dataset():
    dataset = get_QuixBugs_dataset()
    for i in range(len(dataset)):
        item = dataset[i]
        print(f"\n样本 {i+1}:")
        print(f"name: {item['name']}")
        # print(f"问题: {item['question']}")
        # print(f"repo: {item['repo']}")
        print("-" * 50)

        query = 'You are an expert in automated code repair. Given the following buggy Python program, generate a correct version of the code. Please note that you just need to output the python code, without any other text. The original code needs to be repaired: \n' + item['question'] +'\n The name of the code is: ' + item['name']
        inputs = {
            # "input1": "value1",
            # "input2": "value2",
        }

        payload = {
            "inputs": inputs,
            "query": query,
            "response_mode": "blocking",  # 或 "streaming"            
            "user": "abc-123",            # 可选，用户ID
            "conversation_id": ""        # 可选，首次对话留空，后续对话填前一次返回的 conversation_id
        }

        response = requests.post(API_URL, headers=headers, json=payload)
        # print(response.text)

        if response.status_code == 200:
            print("运行成功，原始返回内容如下：")
            print(response.text)  # 先打印原始内容  
            
            data = json.loads(response.text)
            answer = data.get("answer")
            print('answer:', answer)  

            # 提取代码部分
            code_pattern = r'```python\n(.*?)```'
            code_match = re.search(code_pattern, answer, re.DOTALL)
            if code_match:
                answer = code_match.group(1).strip()
            else:
                # 如果没有markdown格式,直接使用answer
                answer = answer.strip()

            # 确保输出目录存在
            output_dir = 'output/Cot/QuixBugs/'
            if not os.path.exists(output_dir):
                os.makedirs(output_dir)
            
            # 将结果写入json文件
            # result = {
            #     "id": item['id'],
            #     "question": item['question'], 
            #     "answer": answer
            # }
            
            # 修改文件扩展名为.json
            output_file = os.path.join(output_dir, item['name'])

            with open(output_file, 'w', encoding='utf-8') as f:
                f.write(answer)
            
            # with open(output_file, 'w', encoding='utf-8') as f:
            #     json.dump(result, f, ensure_ascii=False, indent=2)
            print("运行成功，结果已写入JSON文件：", output_file)


def run_QuixBugs_java_dataset():
    dataset = get_QuixBugs_java_dataset()
    for i in range(len(dataset)):
        item = dataset[i]
        print(f"\n样本 {i+1}:")
        print(f"name: {item['name']}")
        # print(f"问题: {item['question']}")
        # print(f"repo: {item['repo']}")
        print("-" * 50)

        query = 'You are an expert in automated code repair. Given the following buggy java program, generate a correct version of the code. Please note that you just need to output the java code, without any other text. The original code needs to be repaired: \n' + item['question'] +'\n The name of the code is: ' + item['name']
        inputs = {
            # "input1": "value1",
            # "input2": "value2",
        }

        payload = {
            "inputs": inputs,
            "query": query,
            "response_mode": "blocking",  # 或 "streaming"            
            "user": "abc-123",            # 可选，用户ID
            "conversation_id": ""        # 可选，首次对话留空，后续对话填前一次返回的 conversation_id
        }

        response = requests.post(API_URL, headers=headers, json=payload)
        # print(response.text)

        if response.status_code == 200:
            print("运行成功，原始返回内容如下：")
            print(response.text)  # 先打印原始内容  
            
            data = json.loads(response.text)
            answer = data.get("answer")
            print('answer:', answer)  

            # 提取代码部分
            code_pattern = r'```java\n(.*?)```'
            code_match = re.search(code_pattern, answer, re.DOTALL)
            if code_match:
                answer = code_match.group(1).strip()
            else:
                # 如果没有markdown格式,直接使用answer
                answer = answer.strip()

            # 确保输出目录存在
            output_dir = 'output/Cot/QuixBugs-java/'
            if not os.path.exists(output_dir):
                os.makedirs(output_dir)
            
            # 将结果写入json文件
            # result = {
            #     "id": item['id'],
            #     "question": item['question'], 
            #     "answer": answer
            # }
            
            # 修改文件扩展名为.json
            output_file = os.path.join(output_dir, item['name'])

            with open(output_file, 'w', encoding='utf-8') as f:
                f.write(answer)
            
            # with open(output_file, 'w', encoding='utf-8') as f:
            #     json.dump(result, f, ensure_ascii=False, indent=2)
            print("运行成功，结果已写入JSON文件：", output_file)

            
# run_qa_dataset(dataset_qa)
# run_humaneval_dataset(dataset_humaneval)
# run_apps_dataset(dataset_apps)
# run_mbpp_dataset()
# run_swe_dataset()
# run_QuixBugs_dataset()
run_QuixBugs_java_dataset()