import requests

API_KEY = 'app-b37pRq1EJ7Pib3nZeFSUF61l'
API_URL = 'http://localhost/v1/workflows/run'  # 云端请替换为实际地址
USER_ID = "abc-123"
# CONVERSATION_ID = "4df9b765-56dd-4af8-a3f3-5fa7751d7ce1"
# LIMIT = 20
# CHAT_URL = f"http://localhost/v1/messages?user={USER_ID}&conversation_id={CONVERSATION_ID}&limit={LIMIT}"

# # from googletrans import Translator
# from deep_translator import GoogleTranslator

# # translator = Translator()
import pandas as pd
import os
import json, re

from openai import OpenAI

def get_swe_dataset():
    """
    读取parquet文件并返回包含question和final_answer的字典数组
    
    Returns:
        list: 包含字典的列表，每个字典包含'question'和'answer'字段
    """
    try:
        # 文件路径
        file_path = 'templates/dataset/SWE-bench-verified/test-00000-of-00001.parquet'
        
        # 检查文件是否存在
        if not os.path.exists(file_path):
            print(f"文件 {file_path} 不存在")
            return []
        
        # 读取parquet文件
        df = pd.read_parquet(file_path)
        
        # 提取所需数据并转换为字典数组
        swe_dataset = []
        for _, row in df.iterrows():
            instance_id = row['instance_id']
            question = row['problem_statement']
            repo = row['repo']
            hints = row['hints_text']
            swe_dataset.append({
                'id': instance_id,
                'repo': repo,
                'question': question,
                'hints': hints
            })
            
        return swe_dataset
        
    except Exception as e:
        print(f"读取文件时出错: {str(e)}")
        return []
# print(get_swe_dataset())

headers = {
    'Authorization': f'Bearer {API_KEY}',
    'Content-Type': 'application/json'
}

def run_swe_dataset():
    dataset = get_swe_dataset()
    for i in range(0,50):
        item = dataset[i]
        print(f"\n样本 {i+1}:")
        print(f"id: {item['id']}")
        # print(f"问题: {item['question']}")
        # print(f"repo: {item['repo']}")
        print("-" * 50)
        
        query = ''
        #query = "You are a code fixer for generating patch. Given the following problem statement and a GitHub repository link, generate a unified diff patch that fixes the described problem. The patch should be in diff format, suitable for applying with git apply.\n\n Problem Statement:\n"+item['question'] + '\n\nGithub repository link:\nhttps://github.com/'+item['repo'] + '\n\n. The hints are as follows (if there are some hints):\n'+item['hints'] + '\nDo not include any explanations, comments, or extra text—output only the patch.'

        inputs = {
            "issue_description": item['question'],
            "github_url": "https://github.com/"+item['repo'],
            "instance_id": item['id']
            # "input1": "value1",
            # "input2": "value2",
        }

        payload = {
            "inputs": inputs,
            # "query": query,
            "response_mode": "blocking",  # 或 "streaming"            
            "user": "abc-123",            # 可选，用户ID
            "conversation_id": ""        # 可选，首次对话留空，后续对话填前一次返回的 conversation_id
        }

        response = requests.post(API_URL, headers=headers, json=payload)
        print(response.text)

        if response.status_code == 200:
            print("运行成功，原始返回内容如下：")
            #print(response.text)  # 先打印原始内容  
            
            # data = json.loads(response.text)
            # answer = data.get("outputs") 

            # 确保输出目录存在
            output_dir = 'output/APR/SWE-m-verified-6'
            if not os.path.exists(output_dir):
                os.makedirs(output_dir)
            
            # 将结果写入json文件
            result = {
                "id": item['id'],
                "question": item['question'], 
                "answer": response.text
            }
            
            # 修改文件扩展名为.json
            output_file = os.path.join(output_dir, f'swe_log_{i}.json')
            
            with open(output_file, 'w', encoding='utf-8') as f:
                json.dump(result, f, ensure_ascii=False, indent=2)
            print("运行成功，结果已写入JSON文件：", output_file)

run_swe_dataset()

