# Improving Generative Behavior Cloning via Self-Guidance and Adaptive Chunking

Our implementation largely based on BID (Bidirectional Decoding: Improving Action Chunking via Closed-Loop Resampling) repository released by the IRIS Lab at Stanford University.


### Setup

Install dependencies of the diffusion policy
```
[isa]$ conda env create -f conda_environment.yaml
[isa]$ conda activate isa
```

Install additional dependencies
```
[isa]$ pip install -r requirement.txt
```

Download pre-trained checkpoints from BID (Note: This ckpt link is borrowed from officialy opend BID, not ours)
```
[isa]$ mkdir ckpt && cd ckpt 
[ckpt]$ gdown https://drive.google.com/drive/folders/19HzTWuIJGGf2Ezmw2IUzIWId_PhZbrSY?usp=sharing -O . --folder
```


Download Official diffusion policy online data.
```
[isa]& bash script/download_dataset.sh
```

### Evaluation

You can run our simulation enviornment evauluation by `bash script/[task_name]/eval_[method].sh` , as follows  :

- Vanilla Diffusion Policy
```
[isa]$ bash script/pusht/eval_random.sh
```


- Temporal Ensembling Baseline (EMA)
```
[isa]$ bash script/pusht/eval_ema.sh
```

- Bidirectional Decoding (BID)
```
[isa]$ bash script/pusht/eval_bid.sh
```

- Ours (Adaptive Chunking + Self Guidance)
```
[isa]$ bash script/pusht/eval_ours.sh
```
- Adaptive Chunking
```
[isa]$ bash script/pusht/eval_ac.sh
```
- Self Guidance
```
[isa]$ bash script/pusht/eval_sg.sh
```
