#!/bin/bash

TH=16
OH=2
OUTDIR=outputs
METHOD=bid
DECAY=0.5
NSAMPLE=15
NMODE=3

# ===================================================================================================

TASK=can_mh
DIR=ckpt/ckpt/${TASK}
CKPT='epoch=0160-test_mean_score=0.860.ckpt'
REF='epoch=0020-test_mean_score=0.200.ckpt'
# REF='None'

DEV='cuda:2'

TEST_NUM=100
SEED=0
PERTURB=0.0
# ===================================================================================================
alpha=0.0
beta=0.0

# Stochastic
NOISE=1.0
# closed-loop
AH=1
python eval_isa.py --checkpoint ${DIR}/${CKPT} --output_dir ${OUTDIR}/${TASK}/${METHOD}_${NSAMPLE}/${NOISE}/th${TH}_oh${OH}_ah${AH} --sampler ${METHOD} -ah ${AH} --nsample ${NSAMPLE} --nmode ${NMODE} --decay ${DECAY} --reference ${DIR}/${REF} --noise ${NOISE} --ntest ${TEST_NUM} --alpha ${alpha} --beta ${beta} --perturb ${PERTURB} --device ${DEV}

# ===================================================================================================

# Static
NOISE=0.0
# open-loop
AH=8
python eval_isa.py --checkpoint ${DIR}/${CKPT} --output_dir ${OUTDIR}/${TASK}/${METHOD}_${NSAMPLE}/${NOISE}/th${TH}_oh${OH}_ah${AH} --sampler ${METHOD} -ah ${AH} --nsample ${NSAMPLE} --nmode ${NMODE} --decay ${DECAY} --reference ${DIR}/${REF} --noise ${NOISE} --ntest ${TEST_NUM} --alpha ${alpha} --beta ${beta} --perturb ${PERTURB} --device ${DEV}

