#!/bin/bash

TH=16
OH=2
OUTDIR=outputs
METHOD=ema

# ===================================================================================================

TASK=pusht
DIR=ckpt/ckpt/${TASK}
CKPT='epoch=0150-test_mean_score=0.909.ckpt'
REF='None'


DEV='cuda:1'

TEST_NUM=100
SEED=0
PERTURB=0.0
# ===================================================================================================
alpha=0.0
beta=0.5 # StaticEMA(0.5)

# Stochastic
NOISE=1.0
# closed-loop
AH=1
python eval_isa.py --checkpoint ${DIR}/${CKPT} --output_dir ${OUTDIR}/${TASK}/${METHOD}/${NOISE}/th${TH}_oh${OH}_ah${AH} --sampler ${METHOD} -ah ${AH} --noise ${NOISE} --ntest ${TEST_NUM} --device ${DEV} --seed ${SEED} --reference ${DIR}/${REF} --alpha ${alpha} --beta ${beta} --perturb ${PERTURB} 

# Static
NOISE=0.0
# open-loop
AH=8
python eval_isa.py --checkpoint ${DIR}/${CKPT} --output_dir ${OUTDIR}/${TASK}/${METHOD}/${NOISE}/th${TH}_oh${OH}_ah${AH} --sampler ${METHOD} -ah ${AH} --noise ${NOISE} --ntest ${TEST_NUM} --device ${DEV} --seed ${SEED} --reference ${DIR}/${REF} --alpha ${alpha} --beta ${beta} --perturb ${PERTURB} 

