#!/bin/bash

TH=16
OH=2
OUTDIR=outputs
METHOD=random

# ===================================================================================================

TASK=transport_mh
DIR=ckpt/ckpt/${TASK}
CKPT='epoch=0880-test_mean_score=0.720.ckpt'
REF='epoch=0300-test_mean_score=0.300.ckpt'
REF='None'


DEV='cuda:0'

TEST_NUM=100
SEED=0
PERTURB=0.0
# ===================================================================================================

alpha=0.0
beta=0.0

# Stochastic
NOISE=1.0
# closed-loop
AH=1
python eval_isa.py --checkpoint ${DIR}/${CKPT} --output_dir ${OUTDIR}/${TASK}/${METHOD}/${NOISE}/th${TH}_oh${OH}_ah${AH} --sampler ${METHOD} -ah ${AH} --noise ${NOISE} --ntest ${TEST_NUM} --device ${DEV} --seed ${SEED} --reference ${DIR}/${REF} --alpha ${alpha} --beta ${beta} --perturb ${PERTURB} 

# Static
NOISE=0.0
# open-loop
AH=8
python eval_isa.py --checkpoint ${DIR}/${CKPT} --output_dir ${OUTDIR}/${TASK}/${METHOD}/${NOISE}/th${TH}_oh${OH}_ah${AH} --sampler ${METHOD} -ah ${AH} --noise ${NOISE} --ntest ${TEST_NUM} --device ${DEV} --seed ${SEED} --reference ${DIR}/${REF} --alpha ${alpha} --beta ${beta} --perturb ${PERTURB} 

