#!/bin/bash

TH=16
OH=2
OUTDIR=outputs
METHOD=ac
# ===================================================================================================

TASK=square_mh
DIR=ckpt/ckpt/${TASK}
CKPT='epoch=0150-test_mean_score=0.780.ckpt'
REF='epoch=0050-test_mean_score=0.540.ckpt'
REF='None'

DEV='cuda:5'

TEST_NUM=100
SEED=0
PERTURB=0.0
# ===================================================================================================

# Stochastic
NOISE=1.0
# closed-loop
alpha=0.86 # optimal weight (SG)
beta=0.97 # tau (AC)
AH=1
python eval_isa.py --checkpoint ${DIR}/${CKPT} --output_dir ${OUTDIR}/${TASK}/${METHOD}/${NOISE}/th${TH}_oh${OH}_ah${AH} --sampler ${METHOD} -ah ${AH} --noise ${NOISE} --ntest ${TEST_NUM} --device ${DEV} --seed ${SEED} --reference ${DIR}/${REF} --alpha ${alpha} --beta ${beta} --perturb ${PERTURB} 

# Static
NOISE=0.0
# open-loop
alpha=1.25 # optimal weight (SG)
beta=0.99 # tau (AC)
AH=8
python eval_isa.py --checkpoint ${DIR}/${CKPT} --output_dir ${OUTDIR}/${TASK}/${METHOD}/${NOISE}/th${TH}_oh${OH}_ah${AH} --sampler ${METHOD} -ah ${AH} --noise ${NOISE} --ntest ${TEST_NUM} --device ${DEV} --seed ${SEED} --reference ${DIR}/${REF} --alpha ${alpha} --beta ${beta} --perturb ${PERTURB} 

