# ORDRP
Running Escape Room experiments. 

Installation
```bash
docker build -t my-mujoco-env .
```
Run the Docker container with the following command:
```bash
docker run -it my-mujoco-env
```
To access the container's shell, you can use:

```bash
docker exec -it <container_id> /bin/bash
```

Activae conda environment inside docker container:
```bash
conda activate gym_mujoco
```

Run Escape Room experiments. 
```bash
python main.py --env="MazeAnt"      --exp_name="maze_lap"   --epochs=300  --model='lap'  --auto_a -C=8
python main.py --env="MazeAnt"      --exp_name="maze_mop"   --epochs=300  --model='mop'  --auto_a -C=8
python main.py --env="MazeAnt"      --exp_name="maze_sac"   --epochs=300  --model='sac'  --auto_a
```

Running Mujoco benchmark.

```bash
python main.py --env="Ant-v4" --exp_name="t1_ant_sac"             --epochs=300  --model='sac' 
python main.py --env="Ant-v4" --exp_name="t2_ant_mop_auto_a_c_8"  --epochs=300  --model='mop'  --auto_a -C=8 
python main.py --env="Ant-v4" --exp_name="t1_ant_lap"             --epochs=300  --model='lap'  --auto_a -C=6
```


